<?php
/**
 * Invoice PHP Standalone Webapp - Configuration
 * Copy this to config.php and update values for your environment.
 */

return [
    // Application
    'app' => [
        'name' => 'InvoiceApp',
        'url' => 'http://localhost:8080',
        'timezone' => 'Europe/Amsterdam',
        'debug' => true,
        'secret_key' => 'CHANGE-THIS-TO-A-RANDOM-STRING-64-CHARS-LONG',
    ],

    // Database
    'db' => [
        'host' => '127.0.0.1',
        'port' => 3306,
        'name' => 'invoice_app',
        'user' => 'root',
        'pass' => '',
        'charset' => 'utf8mb4',
    ],

    // Session
    'session' => [
        'lifetime' => 7200, // 2 hours
        'name' => 'invoice_session',
    ],

    // Upload limits
    'upload' => [
        'max_size' => 10 * 1024 * 1024, // 10MB
        'allowed_types' => ['pdf', 'jpg', 'jpeg', 'png', 'doc', 'docx', 'xls', 'xlsx'],
    ],

    // SMTP (loaded from settings DB, these are fallback defaults)
    'mail' => [
        'driver' => 'smtp', // smtp or php_mail
    ],

    // PDF
    'pdf' => [
        'engine' => 'dompdf', // dompdf
        'paper_size' => 'A4',
    ],

    // Paths
    'paths' => [
        'storage' => __DIR__ . '/../storage',
        'pdf' => __DIR__ . '/../storage/pdf',
        'attachments' => __DIR__ . '/../storage/attachments',
        'logs' => __DIR__ . '/../storage/logs',
        'templates' => __DIR__ . '/../templates',
        'uploads' => __DIR__ . '/../public/uploads',
    ],
];
