# InvoiceApp - Self-hosted PHP Facturatie Webapp

Een standalone PHP webapp voor facturatie, betalingen en klantenbeheer. Functioneel vergelijkbaar met Zoho Invoice, maar volledig self-hosted.

## 🚀 Installatie (kies 1 van 3 methoden)

### Methode 1: Docker (snelste)

```bash
cp .env.example .env
nano .env                    # Pas wachtwoorden aan
docker compose up -d
# Open http://localhost:8080
```

### Methode 2: Web Installer (browser wizard)

```bash
composer install
chmod -R 775 storage public/uploads config
# Point webserver naar public/ → open in browser → volg de wizard
```

### Methode 3: CLI Installer

```bash
composer install
chmod +x install.sh
./install.sh
```

Unattended: `DB_HOST=localhost DB_PASS=secret ADMIN_EMAIL=admin@bedrijf.nl ./install.sh --unattended`

### Quick Start (development)

```bash
composer install
# Pas config/config.php aan
mysql -u root invoice_app < database/schema.sql && mysql -u root invoice_app < database/seed.sql
php -S localhost:8080 -t public
```

Default login: `admin@example.com` / `admin123`

## Functionaliteiten (Phase 1 MVP)

Dashboard, Klantenbeheer, Producten/Diensten, Facturen (concept→definitief→verzonden→betaald), PDF generatie, Betalingen, Herinneringen (R1/R2/R3), Rapportages (omzet/BTW/aging/export), Gebruikersbeheer (4 rollen), Audit Log.

## Vereisten

PHP 8.1+, MySQL 5.7+/MariaDB 10.3+, Composer, Apache mod_rewrite (of Nginx).

## Na installatie

1. Instellingen → Bedrijfsgegevens (KVK, BTW, IBAN)
2. SMTP configureren voor e-mail
3. `public/install.php` verwijderen
4. Gebruikers aanmaken met juiste rollen
