<?php

use App\Core\Router;
use App\Controllers\PageController;
use App\Controllers\AuthController;
use App\Controllers\PortalController;
use App\Controllers\AdminController;
use App\Controllers\MemberController;
use App\Controllers\InspectieController;
use App\Controllers\TuincontroleController;

$router = new Router();

// ============================================================
// PUBLIEKE ROUTES
// ============================================================
$router->get('/',                   [PageController::class, 'home']);
$router->get('/over-ons',           [PageController::class, 'overOns']);
$router->get('/bestuur',            [PageController::class, 'bestuur']);
$router->get('/commissies',         [PageController::class, 'commissies']);
$router->get('/faciliteiten',       [PageController::class, 'faciliteiten']);
$router->get('/plattegrond',        [PageController::class, 'plattegrond']);
$router->get('/beschikbare-tuinen', [PageController::class, 'beschikbareTuinen']);
$router->get('/contact',            [PageController::class, 'contact']);
$router->get('/ik-wil-een-tuin',    [PageController::class, 'aspirantInfo']);

// ============================================================
// AUTHENTICATIE
// ============================================================
$router->get('/login',              [AuthController::class, 'showLogin']);
$router->post('/login',             [AuthController::class, 'login']);
$router->get('/logout',             [AuthController::class, 'logout']);
$router->get('/wachtwoord-vergeten',  [AuthController::class, 'showForgotPassword']);
$router->post('/wachtwoord-vergeten', [AuthController::class, 'forgotPassword']);

// ============================================================
// LEDENPORTAAL (Beveiligd)
// ============================================================
$router->get('/portaal',            [PortalController::class, 'dashboard'], ['AuthMiddleware']);

// Portaal: Controleur (commissielid)
$router->get('/portaal/inspecties',                         [TuincontroleController::class, 'mijnInspecties'], ['AuthMiddleware']);
$router->get('/portaal/inspecties/start',                   [TuincontroleController::class, 'start'], ['AuthMiddleware']);
$router->post('/portaal/inspecties/create',                 [TuincontroleController::class, 'create'], ['AuthMiddleware']);
$router->get('/portaal/inspecties/{id}',                    [TuincontroleController::class, 'showInspectie'], ['AuthMiddleware']);
$router->get('/portaal/inspecties/{id}/checklist',          [TuincontroleController::class, 'checklist'], ['AuthMiddleware']);
$router->post('/portaal/inspecties/{id}/checklist/save',    [TuincontroleController::class, 'saveChecklist'], ['AuthMiddleware']);
$router->post('/portaal/inspecties/{id}/complete',          [TuincontroleController::class, 'complete'], ['AuthMiddleware']);
$router->post('/portaal/inspecties/{id}/photo',             [TuincontroleController::class, 'uploadPhoto'], ['AuthMiddleware']);

// Portaal: Tuinder (lid)
$router->get('/portaal/mijn-dossier',                       [TuincontroleController::class, 'mijnDossier'], ['AuthMiddleware']);
$router->get('/portaal/herstel/{ticketId}',                 [TuincontroleController::class, 'herstelForm'], ['AuthMiddleware']);
$router->post('/portaal/herstel/{ticketId}/store',          [TuincontroleController::class, 'herstelStore'], ['AuthMiddleware']);

// ============================================================
// ADMIN / BEHEERPANEEL (Beveiligd)
// ============================================================
$router->get('/admin',                          [AdminController::class, 'dashboard'], ['AdminMiddleware']);
$router->get('/admin/paginas',                  [AdminController::class, 'pages'], ['AdminMiddleware']);
$router->get('/admin/paginas/{slug}',           [AdminController::class, 'editPage'], ['AdminMiddleware']);
$router->post('/admin/paginas/{slug}',          [AdminController::class, 'savePage'], ['AdminMiddleware']);
$router->get('/admin/media',                    [AdminController::class, 'media'], ['AdminMiddleware']);
$router->post('/admin/media/upload',            [AdminController::class, 'uploadMedia'], ['AdminMiddleware']);
$router->post('/admin/media/{id}/delete',       [AdminController::class, 'deleteMedia'], ['AdminMiddleware']);
$router->get('/admin/media/json',               [AdminController::class, 'mediaJson'], ['AdminMiddleware']);
$router->get('/admin/menu',                     [AdminController::class, 'menu'], ['AdminMiddleware']);
$router->post('/admin/menu/save',               [AdminController::class, 'saveMenuItem'], ['AdminMiddleware']);
$router->post('/admin/menu/{id}/delete',        [AdminController::class, 'deleteMenuItem'], ['AdminMiddleware']);
$router->post('/admin/menu/order',              [AdminController::class, 'saveMenuOrder'], ['AdminMiddleware']);
$router->get('/admin/instellingen',             [AdminController::class, 'settings'], ['AdminMiddleware']);
$router->post('/admin/instellingen',            [AdminController::class, 'saveSettings'], ['AdminMiddleware']);

// Ledenbeheer
$router->get('/admin/leden',                    [MemberController::class, 'index'], ['AdminMiddleware']);
$router->get('/admin/leden/nieuw',              [MemberController::class, 'create'], ['AdminMiddleware']);
$router->post('/admin/leden',                   [MemberController::class, 'store'], ['AdminMiddleware']);
$router->get('/admin/leden/{id}',               [MemberController::class, 'show'], ['AdminMiddleware']);
$router->get('/admin/leden/{id}/bewerk',        [MemberController::class, 'edit'], ['AdminMiddleware']);
$router->post('/admin/leden/{id}',              [MemberController::class, 'update'], ['AdminMiddleware']);
$router->post('/admin/leden/{id}/deactiveer',   [MemberController::class, 'deactivate'], ['AdminMiddleware']);
$router->post('/admin/leden/{id}/activeer',     [MemberController::class, 'activateUser'], ['AdminMiddleware']);

// Tuinbeheer
$router->get('/admin/tuinen',                   [MemberController::class, 'tuinen'], ['AdminMiddleware']);
$router->get('/admin/tuinen/nieuw',             [MemberController::class, 'tuinForm'], ['AdminMiddleware']);
$router->get('/admin/tuinen/{id}',              [MemberController::class, 'tuinForm'], ['AdminMiddleware']);
$router->post('/admin/tuinen/save',             [MemberController::class, 'tuinSave'], ['AdminMiddleware']);
$router->post('/admin/tuinen/{id}/delete',      [MemberController::class, 'tuinDelete'], ['AdminMiddleware']);

// Tuincontrole
$router->get('/admin/inspecties',                           [InspectieController::class, 'index'], ['AdminMiddleware']);
$router->get('/admin/inspecties/start',                     [InspectieController::class, 'start'], ['AdminMiddleware']);
$router->post('/admin/inspecties/create',                   [InspectieController::class, 'create'], ['AdminMiddleware']);
$router->get('/admin/inspecties/tickets',                   [InspectieController::class, 'tickets'], ['AdminMiddleware']);
$router->get('/admin/inspecties/herstelmeldingen',          [InspectieController::class, 'herstelmeldingen'], ['AdminMiddleware']);
$router->get('/admin/inspecties/herstelmeldingen/{id}',     [InspectieController::class, 'reviewHerstel'], ['AdminMiddleware']);
$router->post('/admin/inspecties/herstelmeldingen/{id}/review', [InspectieController::class, 'saveReviewHerstel'], ['AdminMiddleware']);
$router->get('/admin/inspecties/checkpoints',               [InspectieController::class, 'checkpoints'], ['AdminMiddleware']);
$router->post('/admin/inspecties/checkpoints/save',         [InspectieController::class, 'saveCheckpoint'], ['AdminMiddleware']);
$router->post('/admin/inspecties/checkpoints/delete',       [InspectieController::class, 'deleteCheckpoint'], ['AdminMiddleware']);
$router->post('/admin/inspecties/checkpoints/categorie',    [InspectieController::class, 'saveCategory'], ['AdminMiddleware']);
$router->post('/admin/inspecties/checkpoints/categorie/delete', [InspectieController::class, 'deleteCategory'], ['AdminMiddleware']);
$router->get('/admin/inspecties/dossier/{id}',              [InspectieController::class, 'dossier'], ['AdminMiddleware']);
$router->get('/admin/inspecties/{id}',                      [InspectieController::class, 'show'], ['AdminMiddleware']);
$router->get('/admin/inspecties/{id}/checklist',            [InspectieController::class, 'checklist'], ['AdminMiddleware']);
$router->post('/admin/inspecties/{id}/checklist/save',      [InspectieController::class, 'saveChecklist'], ['AdminMiddleware']);
$router->post('/admin/inspecties/{id}/complete',            [InspectieController::class, 'complete'], ['AdminMiddleware']);
$router->post('/admin/inspecties/{id}/photo',               [InspectieController::class, 'uploadPhoto'], ['AdminMiddleware']);

return $router;
