<?php
$dbContent = $content['body']['inhoud'] ?? '';
if ($dbContent): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="prose prose-lg max-w-none bg-white rounded-xl shadow-sm border border-gray-100 p-8">
        <?= $dbContent ?>
    </div>
</section>
<?php else: ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h1 class="text-3xl font-bold text-gray-900 mb-2">Commissies</h1>
    <p class="text-gray-500 mb-10">Onze vereniging wordt ondersteund door verschillende commissies.</p>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <?php if (!empty($commissies)): ?>
            <?php foreach ($commissies as $commissie): ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-2"><?= e($commissie['naam']) ?></h2>
                <p class="text-gray-600 text-sm leading-relaxed"><?= e($commissie['beschrijving'] ?? 'Geen beschrijving beschikbaar.') ?></p>
                <?php if ($commissie['email']): ?>
                <p class="mt-4 text-sm">
                    📧 <a href="mailto:<?= e($commissie['email']) ?>" class="text-groen-600 hover:underline"><?= e($commissie['email']) ?></a>
                </p>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-span-full text-center text-gray-400 py-8">
                Commissie informatie wordt binnenkort toegevoegd.
            </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?>
