<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($title ?? 'VTV De Beukhoeve') ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'groen': {
                            50: '#f0fdf4', 100: '#dcfce7', 200: '#bbf7d0',
                            300: '#86efac', 400: '#4ade80', 500: '#22c55e',
                            600: '#16a34a', 700: '#15803d', 800: '#166534', 900: '#14532d',
                        },
                        'aarde': {
                            50: '#faf6f1', 100: '#f0e6d3', 200: '#e0cda7',
                            300: '#c9a96e', 400: '#b8904a', 500: '#a07735',
                            600: '#8a6230', 700: '#6f4e2a', 800: '#5c4127', 900: '#4d3623',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        [x-cloak] { display: none !important; }
    </style>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="min-h-screen flex flex-col bg-gray-50 text-gray-800">
    
    <!-- Calamiteit banner -->
    <?php if (!empty($calamiteit)): ?>
    <div class="bg-red-600 text-white px-4 py-3 text-center font-semibold">
        ⚠️ <?= e($calamiteit['titel']) ?>: <?= e($calamiteit['inhoud']) ?>
    </div>
    <?php endif; ?>

    <!-- Header -->
    <header class="bg-white shadow-sm border-b border-gray-200" x-data="{ mobileOpen: false }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <a href="<?= url('/') ?>" class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-groen-600 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                  d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/>
                        </svg>
                    </div>
                    <div>
                        <span class="text-lg font-bold text-groen-800">De Beukhoeve</span>
                        <span class="hidden sm:inline text-sm text-gray-500 ml-1">Volkstuinvereniging</span>
                    </div>
                </a>

                <!-- Desktop Navigation -->
                <nav class="hidden lg:flex items-center space-x-1">
                    <a href="<?= url('/') ?>" class="px-3 py-2 rounded-md text-sm font-medium <?= \App\Core\View::isActive('/') && $_SERVER['REQUEST_URI'] === '/' ? 'text-groen-700 bg-groen-50' : 'text-gray-600 hover:text-groen-700 hover:bg-gray-50' ?>">Home</a>
                    
                    <div class="relative" x-data="{ open: false }" @mouseenter="open = true" @mouseleave="open = false">
                        <button class="px-3 py-2 rounded-md text-sm font-medium text-gray-600 hover:text-groen-700 hover:bg-gray-50 flex items-center">
                            Over ons
                            <svg class="ml-1 w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                        </button>
                        <div x-show="open" x-cloak x-transition class="absolute left-0 mt-0 w-48 bg-white rounded-md shadow-lg border border-gray-100 py-1 z-50">
                            <a href="<?= url('/over-ons') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-groen-50 hover:text-groen-700">Wie zijn wij</a>
                            <a href="<?= url('/bestuur') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-groen-50 hover:text-groen-700">Bestuur</a>
                            <a href="<?= url('/commissies') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-groen-50 hover:text-groen-700">Commissies</a>
                            <a href="<?= url('/faciliteiten') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-groen-50 hover:text-groen-700">Faciliteiten</a>
                        </div>
                    </div>

                    <a href="<?= url('/plattegrond') ?>" class="px-3 py-2 rounded-md text-sm font-medium text-gray-600 hover:text-groen-700 hover:bg-gray-50">Plattegrond</a>
                    <a href="<?= url('/beschikbare-tuinen') ?>" class="px-3 py-2 rounded-md text-sm font-medium text-gray-600 hover:text-groen-700 hover:bg-gray-50">Beschikbare tuinen</a>
                    <a href="<?= url('/contact') ?>" class="px-3 py-2 rounded-md text-sm font-medium text-gray-600 hover:text-groen-700 hover:bg-gray-50">Contact</a>
                </nav>

                <!-- Right side buttons -->
                <div class="flex items-center space-x-3">
                    <a href="<?= url('/ik-wil-een-tuin') ?>" class="hidden sm:inline-flex items-center px-4 py-2 text-sm font-medium text-groen-700 bg-groen-50 border border-groen-200 rounded-lg hover:bg-groen-100 transition">
                        🌱 Ik wil een tuin
                    </a>
                    
                    <?php if ($auth['check']): ?>
                        <a href="<?= url('/portaal') ?>" class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-groen-600 rounded-lg hover:bg-groen-700 transition">
                            Mijn Portaal
                        </a>
                    <?php else: ?>
                        <a href="<?= url('/login') ?>" class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-groen-600 rounded-lg hover:bg-groen-700 transition">
                            Inloggen
                        </a>
                    <?php endif; ?>

                    <!-- Mobile menu button -->
                    <button @click="mobileOpen = !mobileOpen" class="lg:hidden p-2 rounded-md text-gray-500 hover:text-gray-700 hover:bg-gray-100">
                        <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path x-show="!mobileOpen" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                            <path x-show="mobileOpen" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile menu -->
        <div x-show="mobileOpen" x-cloak x-transition class="lg:hidden border-t border-gray-200 bg-white">
            <div class="px-4 py-3 space-y-1">
                <a href="<?= url('/') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Home</a>
                <a href="<?= url('/over-ons') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Wie zijn wij</a>
                <a href="<?= url('/bestuur') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Bestuur</a>
                <a href="<?= url('/commissies') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Commissies</a>
                <a href="<?= url('/faciliteiten') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Faciliteiten</a>
                <a href="<?= url('/plattegrond') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Plattegrond</a>
                <a href="<?= url('/beschikbare-tuinen') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Beschikbare tuinen</a>
                <a href="<?= url('/contact') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-groen-50">Contact</a>
                <a href="<?= url('/ik-wil-een-tuin') ?>" class="block px-3 py-2 rounded-md text-base font-medium text-groen-700 bg-groen-50">🌱 Ik wil een tuin</a>
            </div>
        </div>
    </header>

    <!-- Flash Messages -->
    <?php foreach (['success' => 'green', 'error' => 'red', 'warning' => 'yellow', 'info' => 'blue'] as $type => $color): ?>
        <?php if (!empty($flash[$type])): ?>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-4" 
             x-data="{ show: true }" x-show="show" x-transition
             x-init="setTimeout(() => show = false, 5000)">
            <div class="rounded-lg bg-<?= $color ?>-50 border border-<?= $color ?>-200 p-4 flex justify-between items-center">
                <p class="text-sm text-<?= $color ?>-800"><?= e($flash[$type]) ?></p>
                <button @click="show = false" class="text-<?= $color ?>-500 hover:text-<?= $color ?>-700">
                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                </button>
            </div>
        </div>
        <?php endif; ?>
    <?php endforeach; ?>

    <!-- Main Content -->
    <main class="flex-1">
        <?= $content ?>
    </main>

    <!-- Footer -->
    <footer class="bg-groen-900 text-white mt-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-lg font-semibold mb-4">VTV De Beukhoeve</h3>
                    <p class="text-groen-200 text-sm leading-relaxed">
                        Volkstuinvereniging De Beukhoeve is een bruisende vereniging waar tuinieren centraal staat.
                    </p>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Snelkoppelingen</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?= url('/over-ons') ?>" class="text-groen-200 hover:text-white transition">Over ons</a></li>
                        <li><a href="<?= url('/beschikbare-tuinen') ?>" class="text-groen-200 hover:text-white transition">Beschikbare tuinen</a></li>
                        <li><a href="<?= url('/ik-wil-een-tuin') ?>" class="text-groen-200 hover:text-white transition">Aspirant worden</a></li>
                        <li><a href="<?= url('/contact') ?>" class="text-groen-200 hover:text-white transition">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Contact</h3>
                    <div class="text-sm text-groen-200 space-y-2">
                        <p>📍 Beukhoevelaan 1, Amsterdam</p>
                        <p>📧 info@beukhoeve.nl</p>
                        <p>📞 020-1234567</p>
                    </div>
                </div>
            </div>
            <div class="mt-8 pt-8 border-t border-groen-800 text-center text-sm text-groen-300">
                &copy; <?= date('Y') ?> VTV De Beukhoeve. Alle rechten voorbehouden.
                <span class="mx-2">|</span>
                <a href="<?= url('/privacy') ?>" class="hover:text-white transition">Privacybeleid</a>
            </div>
        </div>
    </footer>

</body>
</html>
