<?php
/**
 * Global Helper Functions
 * 
 * Dit bestand bevat functies die in alle views beschikbaar zijn.
 * Ze staan NIET in een namespace zodat templates ze direct kunnen aanroepen.
 */

use App\Core\View;
use App\Core\Session;

function e(?string $value): string
{
    return htmlspecialchars($value ?? '', ENT_QUOTES, 'UTF-8');
}

function url(string $path = ''): string
{
    return View::url($path);
}

function csrf_field(): string
{
    $token = Session::generateCsrfToken();
    return '<input type="hidden" name="_csrf_token" value="' . e($token) . '">';
}

function old(string $key, string $default = ''): string
{
    return e(Session::getFlash('old_' . $key, $default));
}

function asset(string $path): string
{
    return View::basePath() . '/public/assets/' . ltrim($path, '/');
}

function menu_items(): array
{
    try {
        return \App\Models\Menu::getTree();
    } catch (\Exception $e) {
        return []; // Failsafe als tabel nog niet bestaat
    }
}

function setting(string $key, string $default = ''): string
{
    try {
        return \App\Models\Setting::get($key, $default);
    } catch (\Exception $e) {
        return $default;
    }
}

function media_url(string $path): string
{
    return \App\Models\Media::url($path);
}
