<?php
/**
 * VTV De Beukhoeve - Root Bootstrap
 * 
 * Dit bestand vangt alle requests op en stuurt ze
 * door naar public/index.php. Werkt ook zonder .htaccess.
 */

// Stel het werkdirectory in op public/
$publicDir = __DIR__ . '/public';

// Als er een specifiek bestand in public/ gevraagd wordt (CSS, JS, images)
$requestUri = $_SERVER['REQUEST_URI'] ?? '';
$path = parse_url($requestUri, PHP_URL_PATH);

// Strip de base directory uit het pad
$scriptDir = dirname($_SERVER['SCRIPT_NAME']);
$relativePath = $path;
if ($scriptDir !== '/' && str_starts_with($path, $scriptDir)) {
    $relativePath = substr($path, strlen($scriptDir));
}
$relativePath = ltrim($relativePath, '/');

// Check of het een bestaand bestand is in public/ (assets etc.)
if ($relativePath && $relativePath !== 'index.php') {
    $publicFile = $publicDir . '/' . $relativePath;
    // Ook check in root dir voor storage/uploads/
    $rootFile = __DIR__ . '/' . $relativePath;
    
    $serveFile = null;
    if (is_file($publicFile)) {
        $serveFile = $publicFile;
    } elseif (str_starts_with($relativePath, 'storage/uploads/') && is_file($rootFile)) {
        $serveFile = $rootFile;
    }
    
    if ($serveFile) {
        // Bepaal MIME type
        $ext = strtolower(pathinfo($serveFile, PATHINFO_EXTENSION));
        $mimeTypes = [
            'css' => 'text/css',
            'js' => 'application/javascript',
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'webp' => 'image/webp',
            'svg' => 'image/svg+xml',
            'ico' => 'image/x-icon',
            'woff' => 'font/woff',
            'woff2' => 'font/woff2',
            'pdf' => 'application/pdf',
        ];
        if (isset($mimeTypes[$ext])) {
            header('Content-Type: ' . $mimeTypes[$ext]);
            header('Cache-Control: public, max-age=86400');
            readfile($serveFile);
            exit;
        }
    }
}

// Blokkeer directe toegang tot gevoelige mappen
// Sta storage/uploads/ toe voor media bestanden
$blocked = ['app/', 'config/', 'database/', 'vendor/'];
foreach ($blocked as $dir) {
    if (str_starts_with($relativePath, $dir)) {
        http_response_code(403);
        die('Toegang geweigerd.');
    }
}
// Blokkeer storage/ BEHALVE storage/uploads/
if (str_starts_with($relativePath, 'storage/') && !str_starts_with($relativePath, 'storage/uploads/')) {
    http_response_code(403);
    die('Toegang geweigerd.');
}

// Blokkeer gevoelige bestanden
if (preg_match('/\.(env|sql|sh|log)$/i', $relativePath)) {
    http_response_code(403);
    die('Toegang geweigerd.');
}

// Laad de front controller
require $publicDir . '/index.php';
