-- ============================================================
-- VTV De Beukhoeve - Migratie 002: Content Management
-- ============================================================

-- Pagina content (bewerkbare inhoud per pagina)
CREATE TABLE IF NOT EXISTS pagina_content (
    id INT AUTO_INCREMENT PRIMARY KEY,
    pagina_slug VARCHAR(100) NOT NULL,
    sectie VARCHAR(100) NOT NULL DEFAULT 'body',
    titel VARCHAR(255) NULL,
    inhoud LONGTEXT NULL,
    afbeelding_pad VARCHAR(500) NULL,
    volgorde INT DEFAULT 0,
    actief TINYINT(1) DEFAULT 1,
    bijgewerkt_door INT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_pagina_sectie (pagina_slug, sectie),
    FOREIGN KEY (bijgewerkt_door) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Media bibliotheek
CREATE TABLE IF NOT EXISTS media (
    id INT AUTO_INCREMENT PRIMARY KEY,
    bestandsnaam VARCHAR(255) NOT NULL,
    originele_naam VARCHAR(255) NOT NULL,
    mime_type VARCHAR(100) NOT NULL,
    bestandsgrootte INT NOT NULL,
    breedte INT NULL,
    hoogte INT NULL,
    alt_tekst VARCHAR(255) NULL,
    map VARCHAR(100) DEFAULT 'algemeen',
    geupload_door INT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (geupload_door) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Menu items (aanpasbare navigatie)
CREATE TABLE IF NOT EXISTS menu_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    parent_id INT NULL,
    titel VARCHAR(100) NOT NULL,
    url VARCHAR(255) NOT NULL,
    icoon VARCHAR(50) NULL,
    volgorde INT DEFAULT 0,
    actief TINYINT(1) DEFAULT 1,
    alleen_ingelogd TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (parent_id) REFERENCES menu_items(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Site instellingen (key-value)
CREATE TABLE IF NOT EXISTS site_instellingen (
    id INT AUTO_INCREMENT PRIMARY KEY,
    sleutel VARCHAR(100) NOT NULL UNIQUE,
    waarde TEXT NULL,
    type ENUM('text', 'textarea', 'image', 'boolean', 'number', 'color', 'json') DEFAULT 'text',
    groep VARCHAR(50) DEFAULT 'algemeen',
    label VARCHAR(255) NULL,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Bestuur leden (bewerkbaar)
CREATE TABLE IF NOT EXISTS bestuur_leden (
    id INT AUTO_INCREMENT PRIMARY KEY,
    naam VARCHAR(150) NOT NULL,
    functie VARCHAR(100) NOT NULL,
    email VARCHAR(255) NULL,
    telefoon VARCHAR(20) NULL,
    foto_pad VARCHAR(500) NULL,
    bio TEXT NULL,
    volgorde INT DEFAULT 0,
    actief TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================================
-- Standaard menu items
-- ============================================================
INSERT INTO menu_items (parent_id, titel, url, volgorde, actief) VALUES
(NULL, 'Home', '/', 1, 1),
(NULL, 'Vereniging', '#', 2, 1),
(NULL, 'Tuinen', '#', 3, 1),
(NULL, 'Contact', '/contact', 4, 1);

-- Submenu Vereniging
SET @vereniging_id = (SELECT id FROM menu_items WHERE titel = 'Vereniging' AND parent_id IS NULL);
INSERT INTO menu_items (parent_id, titel, url, volgorde, actief) VALUES
(@vereniging_id, 'Wie zijn wij', '/over-ons', 1, 1),
(@vereniging_id, 'Bestuur', '/bestuur', 2, 1),
(@vereniging_id, 'Commissies', '/commissies', 3, 1),
(@vereniging_id, 'Faciliteiten', '/faciliteiten', 4, 1);

-- Submenu Tuinen
SET @tuinen_id = (SELECT id FROM menu_items WHERE titel = 'Tuinen' AND parent_id IS NULL);
INSERT INTO menu_items (parent_id, titel, url, volgorde, actief) VALUES
(@tuinen_id, 'Plattegrond', '/plattegrond', 1, 1),
(@tuinen_id, 'Beschikbare tuinen', '/beschikbare-tuinen', 2, 1),
(@tuinen_id, 'Ik wil een tuin', '/ik-wil-een-tuin', 3, 1);

-- ============================================================
-- Standaard pagina content
-- ============================================================
INSERT INTO pagina_content (pagina_slug, sectie, titel, inhoud) VALUES
('home', 'hero_titel', 'Hero Titel', 'Welkom bij VTV De Beukhoeve'),
('home', 'hero_subtitel', 'Hero Subtitel', 'Al jaren een groene oase in de stad. Ontdek onze gemeenschap, wordt lid en geniet van uw eigen volkstuin.'),
('home', 'hero_afbeelding', 'Hero Afbeelding', NULL),
('over-ons', 'body', 'Over ons', '<h2>Wie zijn wij</h2><p>VTV De Beukhoeve is een bloeiende volkstuinvereniging waar natuur en gemeenschap samenkomen. Al jaren bieden wij onze leden een groene oase midden in de stad.</p><h3>Onze waarden</h3><p><strong>Groen</strong> — Wij koesteren de natuur en moedigen duurzaam tuinieren aan.</p><p><strong>Gemeenschap</strong> — Samen maken we er iets moois van. Van gezamenlijke werkdagen tot gezellige evenementen.</p><p><strong>Rust</strong> — Uw tuin is uw eigen stukje rust in een drukke wereld.</p>'),
('bestuur', 'body', 'Bestuur', '<p>Het bestuur van VTV De Beukhoeve zet zich vrijwillig in voor het beheer en de ontwikkeling van onze vereniging.</p>'),
('commissies', 'body', 'Commissies', '<p>Onze vereniging draait op de inzet van vrijwilligers in diverse commissies.</p>'),
('faciliteiten', 'body', 'Faciliteiten', '<p>VTV De Beukhoeve beschikt over diverse faciliteiten voor onze leden.</p>'),
('plattegrond', 'body', 'Plattegrond', '<p>Bekijk hier de plattegrond van ons complex.</p>'),
('beschikbare-tuinen', 'body', 'Beschikbare tuinen', '<p>Op dit moment zijn de volgende tuinen beschikbaar voor nieuwe leden.</p>'),
('contact', 'body', 'Contact', '<p>Neem gerust contact met ons op. Wij helpen u graag verder.</p>'),
('aspirant-info', 'body', 'Word lid', '<p>Wilt u lid worden van VTV De Beukhoeve? Hieronder leest u hoe het aspirant-lidmaatschap werkt.</p>');

-- ============================================================
-- Standaard site instellingen
-- ============================================================
INSERT INTO site_instellingen (sleutel, waarde, type, groep, label) VALUES
('site_naam', 'VTV De Beukhoeve', 'text', 'algemeen', 'Naam van de vereniging'),
('site_beschrijving', 'Volkstuinvereniging De Beukhoeve', 'text', 'algemeen', 'Korte beschrijving'),
('contact_email', 'info@beukhoeve.nl', 'text', 'contact', 'Contact e-mailadres'),
('contact_telefoon', '', 'text', 'contact', 'Telefoonnummer'),
('contact_adres', '', 'textarea', 'contact', 'Bezoekadres'),
('openingstijden', '', 'textarea', 'contact', 'Openingstijden'),
('facebook_url', '', 'text', 'social', 'Facebook pagina URL'),
('instagram_url', '', 'text', 'social', 'Instagram URL'),
('primaire_kleur', '#16a34a', 'color', 'uiterlijk', 'Primaire kleur'),
('logo_pad', '', 'image', 'uiterlijk', 'Logo'),
('favicon_pad', '', 'image', 'uiterlijk', 'Favicon');
