<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Tuincontrole</h1>
        <p class="text-sm text-gray-500 mt-1"><?= $totaal ?> inspecties · <?= $openTickets ?> open tickets · <?= $pendingHerstel ?> wachtend op beoordeling</p>
    </div>
    <a href="<?= url('/admin/inspecties/start') ?>" class="px-4 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 flex items-center space-x-2">
        <span>🔍 Inspectie starten</span>
    </a>
</div>

<!-- Quick links -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
    <a href="<?= url('/admin/inspecties/tickets') ?>" class="bg-white rounded-xl border p-4 hover:shadow-md transition">
        <p class="text-2xl font-bold text-orange-600"><?= $openTickets ?></p>
        <p class="text-sm text-gray-500">Open tickets</p>
    </a>
    <a href="<?= url('/admin/inspecties/herstelmeldingen?status=ingediend') ?>" class="bg-white rounded-xl border p-4 hover:shadow-md transition">
        <p class="text-2xl font-bold text-blue-600"><?= $pendingHerstel ?></p>
        <p class="text-sm text-gray-500">Te beoordelen</p>
    </a>
    <a href="<?= url('/admin/inspecties/checkpoints') ?>" class="bg-white rounded-xl border p-4 hover:shadow-md transition">
        <p class="text-2xl font-bold text-gray-600">⚙️</p>
        <p class="text-sm text-gray-500">Controle punten</p>
    </a>
    <a href="<?= url('/admin/inspecties/start') ?>" class="bg-white rounded-xl border p-4 hover:shadow-md transition bg-groen-50">
        <p class="text-2xl font-bold text-groen-600">+</p>
        <p class="text-sm text-gray-500">Nieuwe inspectie</p>
    </a>
</div>

<!-- Filters -->
<div class="flex gap-2 mb-4">
    <a href="<?= url('/admin/inspecties') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= !$filters['status'] ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Alle</a>
    <a href="<?= url('/admin/inspecties?status=gestart') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $filters['status'] === 'gestart' ? 'bg-yellow-500 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Lopend</a>
    <a href="<?= url('/admin/inspecties?status=afgerond') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $filters['status'] === 'afgerond' ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Afgerond</a>
</div>

<!-- Lijst -->
<div class="bg-white rounded-xl border overflow-hidden">
    <table class="w-full">
        <thead class="bg-gray-50 border-b"><tr>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">ID</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tuin</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Inspecteur</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Datum</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Status</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Resultaat</th>
            <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase">Acties</th>
        </tr></thead>
        <tbody class="divide-y divide-gray-100">
            <?php if (empty($inspecties)): ?>
            <tr><td colspan="7" class="px-4 py-8 text-center text-gray-400">Nog geen inspecties</td></tr>
            <?php endif; ?>
            <?php foreach ($inspecties as $i): ?>
            <tr class="hover:bg-gray-50">
                <td class="px-4 py-3 text-sm text-gray-500">#<?= $i['id'] ?></td>
                <td class="px-4 py-3 text-sm font-bold text-groen-700">
                    <a href="<?= url('/admin/inspecties/dossier/' . $i['tuin_id']) ?>"><?= e($i['tuinnummer']) ?></a>
                </td>
                <td class="px-4 py-3 text-sm"><?= e($i['inspecteur_voornaam'] . ' ' . $i['inspecteur_achternaam']) ?></td>
                <td class="px-4 py-3 text-sm text-gray-500"><?= date('d-m-Y H:i', strtotime($i['gestart_op'])) ?></td>
                <td class="px-4 py-3">
                    <?php if ($i['status'] === 'gestart'): ?>
                    <span class="text-xs px-2 py-1 rounded-full bg-yellow-100 text-yellow-700">Lopend</span>
                    <?php elseif ($i['status'] === 'afgerond'): ?>
                    <span class="text-xs px-2 py-1 rounded-full bg-groen-100 text-groen-700">Afgerond</span>
                    <?php else: ?>
                    <span class="text-xs px-2 py-1 rounded-full bg-gray-100 text-gray-600"><?= e($i['status']) ?></span>
                    <?php endif; ?>
                </td>
                <td class="px-4 py-3">
                    <?php if ($i['weigert_medewerking']): ?>
                    <span class="text-xs font-bold text-red-600">⛔ Weigering</span>
                    <?php elseif ($i['eindstatus']): ?>
                    <?php
                    $kleuren = ['groen' => 'bg-green-100 text-green-700', 'oranje' => 'bg-orange-100 text-orange-700', 'rood' => 'bg-red-100 text-red-700'];
                    ?>
                    <span class="text-xs px-2 py-1 rounded-full <?= $kleuren[$i['eindstatus']] ?? '' ?>"><?= ucfirst($i['eindstatus']) ?></span>
                    <?php else: ?>
                    <span class="text-gray-400">—</span>
                    <?php endif; ?>
                </td>
                <td class="px-4 py-3 text-right">
                    <?php if ($i['status'] === 'gestart'): ?>
                    <a href="<?= url('/admin/inspecties/' . $i['id'] . '/checklist') ?>" class="text-sm text-blue-600 hover:text-blue-800">Checklist →</a>
                    <?php else: ?>
                    <a href="<?= url('/admin/inspecties/' . $i['id']) ?>" class="text-sm text-blue-600 hover:text-blue-800">Details</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
