<?php

namespace App\Models;

use App\Core\Database;

class Menu
{
    /**
     * Haal het volledige menu op (genest)
     */
    public static function getTree(): array
    {
        $db = Database::getInstance();
        $items = $db->fetchAll(
            "SELECT * FROM menu_items WHERE actief = 1 ORDER BY volgorde ASC"
        );

        return self::buildTree($items);
    }

    /**
     * Haal alle menu items plat op (voor admin)
     */
    public static function getAll(): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT m.*, p.titel as parent_titel 
             FROM menu_items m 
             LEFT JOIN menu_items p ON m.parent_id = p.id 
             ORDER BY m.parent_id IS NULL DESC, m.parent_id, m.volgorde"
        );
    }

    /**
     * Vind een menu item
     */
    public static function find(int $id): ?array
    {
        $db = Database::getInstance();
        return $db->fetch("SELECT * FROM menu_items WHERE id = ?", [$id]);
    }

    /**
     * Maak een menu item aan
     */
    public static function create(array $data): int
    {
        $db = Database::getInstance();
        return $db->insert('menu_items', $data);
    }

    /**
     * Update een menu item
     */
    public static function update(int $id, array $data): bool
    {
        $db = Database::getInstance();
        return $db->update('menu_items', $data, 'id = ?', [$id]);
    }

    /**
     * Verwijder een menu item
     */
    public static function delete(int $id): bool
    {
        $db = Database::getInstance();
        return $db->delete('menu_items', 'id = ?', [$id]);
    }

    /**
     * Update volgorde (array van id => volgorde)
     */
    public static function updateOrder(array $order): void
    {
        $db = Database::getInstance();
        foreach ($order as $id => $volgorde) {
            $db->update('menu_items', ['volgorde' => (int)$volgorde], 'id = ?', [(int)$id]);
        }
    }

    /**
     * Haal alleen top-level items op (voor parent dropdown)
     */
    public static function getParents(): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT id, titel FROM menu_items WHERE parent_id IS NULL ORDER BY volgorde"
        );
    }

    /**
     * Bouw geneste boomstructuur
     */
    private static function buildTree(array $items, ?int $parentId = null): array
    {
        $tree = [];
        foreach ($items as $item) {
            if ($item['parent_id'] == $parentId) {
                $item['children'] = self::buildTree($items, $item['id']);
                $tree[] = $item;
            }
        }
        return $tree;
    }
}
