<?php
$heroTitel = $content['hero_titel']['inhoud'] ?? 'ontdek uw eigen groene oase';
$heroSubtitel = $content['hero_subtitel']['inhoud'] ?? 'Wij zijn een trotse volkstuinvereniging waar natuur, rust en gemeenschap samenkomen. Al jaren een groene thuisbasis voor tuinliefhebbers.';
$heroAfbeelding = $content['hero_afbeelding']['afbeelding_pad'] ?? '';
$sliderActief = ($content['hero_slider_actief']['inhoud'] ?? '0') === '1';
$sliderFotos = json_decode($content['hero_slider_fotos']['inhoud'] ?? '[]', true) ?: [];
?>

<!-- HERO -->
<section class="relative min-h-[90vh] flex items-center overflow-hidden grain">
    <!-- Background -->
    <div class="absolute inset-0 bg-donker">
        <?php if ($sliderActief && count($sliderFotos) > 0): ?>
        <!-- SLIDER MODE -->
        <div x-data="heroSlider()" x-init="startSlider()" class="absolute inset-0">
            <?php foreach ($sliderFotos as $i => $foto): ?>
            <img src="<?= url('/storage/uploads/media/' . $foto) ?>" alt="" 
                 class="absolute inset-0 w-full h-full object-cover transition-opacity duration-[2000ms]"
                 :class="currentSlide === <?= $i ?> ? 'opacity-30' : 'opacity-0'">
            <?php endforeach; ?>
        </div>
        <?php elseif ($heroAfbeelding): ?>
        <!-- ENKELE AFBEELDING -->
        <img src="<?= url('/storage/uploads/media/' . $heroAfbeelding) ?>" alt="" class="w-full h-full object-cover opacity-30">
        <?php else: ?>
        <!-- GEEN AFBEELDING — gradient -->
        <div class="absolute inset-0" style="background: radial-gradient(ellipse at 70% 50%, rgba(22,163,74,0.15) 0%, transparent 60%), radial-gradient(ellipse at 30% 80%, rgba(22,163,74,0.08) 0%, transparent 50%);"></div>
        <?php endif; ?>
        <!-- Decorative elements -->
        <div class="absolute top-20 right-20 w-96 h-96 bg-groen-500/5 rounded-full blur-3xl"></div>
        <div class="absolute bottom-20 left-10 w-64 h-64 bg-groen-500/5 rounded-full blur-3xl"></div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-32 lg:py-40 w-full">
        <div class="max-w-4xl">
            <div class="animate-fade-up">
                <span class="inline-flex items-center px-4 py-1.5 rounded-full bg-groen-500/10 border border-groen-500/20 text-groen-400 text-xs font-semibold uppercase tracking-widest mb-8">
                    <span class="w-2 h-2 bg-groen-400 rounded-full mr-2 animate-pulse"></span>
                    Volkstuinvereniging De Beukhoeve
                </span>
            </div>
            <h1 class="font-display text-5xl sm:text-6xl lg:text-7xl xl:text-8xl text-white leading-[0.95] mb-8 animate-fade-up delay-100">
                <?= str_replace('VTV De Beukhoeve', '<span class="text-orange-500">VTV De Beukhoeve</span>', e($heroTitel)) ?>
            </h1>
            <p class="text-lg sm:text-xl text-white/60 max-w-2xl leading-relaxed mb-10 animate-fade-up delay-200">
                <?= e($heroSubtitel) ?>
            </p>
            <div class="flex flex-wrap gap-4 animate-fade-up delay-300">
                <a href="<?= url('/ik-wil-een-tuin') ?>" class="group inline-flex items-center px-7 py-4 bg-groen-500 text-white font-semibold rounded-xl hover:bg-groen-400 transition-all shadow-lg shadow-groen-500/25 hover:shadow-groen-400/30">
                    Ik wil een tuin
                    <svg class="ml-2 w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
                </a>
                <a href="<?= url('/over-ons') ?>" class="inline-flex items-center px-7 py-4 border border-white/20 text-white font-semibold rounded-xl hover:bg-white/5 transition-all">
                    Ontdek meer
                </a>
            </div>
        </div>

        <!-- Stats bar -->
        <div class="mt-20 pt-10 border-t border-white/10 grid grid-cols-2 sm:grid-cols-4 gap-8 animate-fade-up delay-400">
            <div>
                <p class="text-3xl lg:text-4xl font-display text-orange-500">100+</p>
                <p class="text-sm text-white/40 mt-1">Tuinen op ons complex</p>
            </div>
            <div>
                <p class="text-3xl lg:text-4xl font-display text-orange-500"><?= date('Y') - 1960 ?>+</p>
                <p class="text-sm text-white/40 mt-1">Jaar ervaring</p>
            </div>
            <div>
                <p class="text-3xl lg:text-4xl font-display text-orange-500"><?= (int)($beschikbare_tuinen ?? 0) ?></p>
                <p class="text-sm text-white/40 mt-1">Tuinen beschikbaar</p>
            </div>
            <div>
                <p class="text-3xl lg:text-4xl font-display text-orange-500">♻️</p>
                <p class="text-sm text-white/40 mt-1">Duurzaam & biologisch</p>
            </div>
        </div>
    </div>

    <!-- Scroll indicator -->
    <div class="absolute bottom-8 left-1/2 -translate-x-1/2 animate-bounce">
        <div class="w-6 h-10 border-2 border-white/20 rounded-full flex items-start justify-center p-1.5">
            <div class="w-1.5 h-3 bg-groen-400 rounded-full animate-pulse"></div>
        </div>
    </div>
</section>

<!-- BESCHIKBARE TUINEN BANNER -->
<?php if (($beschikbare_tuinen ?? 0) > 0): ?>
<div class="bg-groen-600 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-5 flex flex-col sm:flex-row items-center justify-between gap-4">
        <div class="flex items-center space-x-3">
            <span class="text-2xl">🌿</span>
            <p class="font-semibold"><?= (int)$beschikbare_tuinen ?> tuin(en) beschikbaar — bekijk ze nu!</p>
        </div>
        <a href="<?= url('/beschikbare-tuinen') ?>" class="px-5 py-2 bg-white text-groen-700 font-semibold rounded-lg hover:bg-groen-50 transition text-sm shrink-0">
            Bekijk tuinen →
        </a>
    </div>
</div>
<?php endif; ?>

<!-- WAT WIJ BIEDEN -->
<section class="py-20 lg:py-28 bg-creme">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col lg:flex-row lg:items-end lg:justify-between gap-6 mb-14">
            <div>
                <span class="text-xs font-semibold uppercase tracking-widest text-groen-600 mb-3 block">[ wat wij bieden ]</span>
                <h2 class="font-display text-3xl sm:text-4xl lg:text-5xl text-donker leading-tight">Meer dan alleen een<br>stukje grond</h2>
            </div>
            <p class="text-gray-500 max-w-md text-sm leading-relaxed lg:text-right">Onze vereniging biedt niet alleen een tuin, maar een complete gemeenschap met faciliteiten, evenementen en ondersteuning.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="group bg-white rounded-2xl p-8 border border-gray-100 hover:border-groen-200 hover:shadow-xl hover:shadow-groen-100/50 transition-all duration-300">
                <div class="w-14 h-14 bg-groen-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-groen-500 transition-colors">
                    <svg class="w-7 h-7 text-groen-600 group-hover:text-white transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064"/></svg>
                </div>
                <h3 class="text-xl font-bold text-donker mb-3">Eigen volkstuin</h3>
                <p class="text-gray-500 text-sm leading-relaxed">Geniet van uw eigen stukje natuur. Van groenten en fruit tot bloemen en ontspanning — uw tuin, uw keuze.</p>
            </div>

            <div class="group bg-white rounded-2xl p-8 border border-gray-100 hover:border-groen-200 hover:shadow-xl hover:shadow-groen-100/50 transition-all duration-300">
                <div class="w-14 h-14 bg-groen-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-groen-500 transition-colors">
                    <svg class="w-7 h-7 text-groen-600 group-hover:text-white transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                </div>
                <h3 class="text-xl font-bold text-donker mb-3">Gemeenschap</h3>
                <p class="text-gray-500 text-sm leading-relaxed">Word onderdeel van een hechte groep tuinliefhebbers. Samen werken, leren en genieten op ons complex.</p>
            </div>

            <div class="group bg-white rounded-2xl p-8 border border-gray-100 hover:border-groen-200 hover:shadow-xl hover:shadow-groen-100/50 transition-all duration-300">
                <div class="w-14 h-14 bg-groen-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-groen-500 transition-colors">
                    <svg class="w-7 h-7 text-groen-600 group-hover:text-white transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/></svg>
                </div>
                <h3 class="text-xl font-bold text-donker mb-3">Faciliteiten</h3>
                <p class="text-gray-500 text-sm leading-relaxed">Gebruik onze gezamenlijke voorzieningen: wateraansluitingen, gereedschap, het verenigingsgebouw en meer.</p>
            </div>

            <div class="group bg-white rounded-2xl p-8 border border-gray-100 hover:border-groen-200 hover:shadow-xl hover:shadow-groen-100/50 transition-all duration-300">
                <div class="w-14 h-14 bg-groen-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-groen-500 transition-colors">
                    <svg class="w-7 h-7 text-groen-600 group-hover:text-white transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                </div>
                <h3 class="text-xl font-bold text-donker mb-3">Evenementen</h3>
                <p class="text-gray-500 text-sm leading-relaxed">Van werkdagen en seizoensopeningen tot barbecues en workshops — er is altijd iets te doen.</p>
            </div>

            <div class="group bg-white rounded-2xl p-8 border border-gray-100 hover:border-groen-200 hover:shadow-xl hover:shadow-groen-100/50 transition-all duration-300">
                <div class="w-14 h-14 bg-groen-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-groen-500 transition-colors">
                    <svg class="w-7 h-7 text-groen-600 group-hover:text-white transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                </div>
                <h3 class="text-xl font-bold text-donker mb-3">Begeleiding</h3>
                <p class="text-gray-500 text-sm leading-relaxed">Nieuw met tuinieren? Ervaren leden helpen u graag op weg met tips, advies en begeleiding.</p>
            </div>

            <div class="group bg-donker rounded-2xl p-8 border border-donker hover:shadow-xl transition-all duration-300 flex flex-col justify-between">
                <div>
                    <span class="text-groen-400 text-xs font-semibold uppercase tracking-widest">Interesse?</span>
                    <h3 class="text-2xl font-display text-white mt-3 mb-4">Word lid van<br>onze vereniging</h3>
                    <p class="text-white/50 text-sm leading-relaxed">Schrijf u in als aspirant-lid en begin aan uw eigen tuinavontuur.</p>
                </div>
                <a href="<?= url('/ik-wil-een-tuin') ?>" class="mt-6 inline-flex items-center text-groen-400 font-semibold text-sm group/link">
                    Meer informatie
                    <svg class="ml-2 w-5 h-5 group-hover/link:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- HOE WERKT HET -->
<section class="py-20 lg:py-28 bg-donker grain relative overflow-hidden">
    <div class="absolute top-0 right-0 w-[500px] h-[500px] bg-groen-500/5 rounded-full blur-3xl"></div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-16">
            <span class="text-xs font-semibold uppercase tracking-widest text-groen-400 mb-3 block">[ hoe het werkt ]</span>
            <h2 class="font-display text-3xl sm:text-4xl lg:text-5xl text-white leading-tight">In drie stappen<br>lid worden</h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 lg:gap-12">
            <div class="relative text-center">
                <div class="w-20 h-20 mx-auto bg-groen-500/10 border border-groen-500/20 rounded-2xl flex items-center justify-center mb-6">
                    <span class="text-3xl font-display text-groen-400">01</span>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Aanmelden</h3>
                <p class="text-white/50 text-sm leading-relaxed">Meld u aan als aspirant-lid via onze website of neem contact op met het bestuur.</p>
                <div class="hidden md:block absolute top-10 -right-6 lg:-right-8 w-12 text-groen-500/30">
                    <svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
                </div>
            </div>
            <div class="relative text-center">
                <div class="w-20 h-20 mx-auto bg-groen-500/10 border border-groen-500/20 rounded-2xl flex items-center justify-center mb-6">
                    <span class="text-3xl font-display text-groen-400">02</span>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Wachtlijst</h3>
                <p class="text-white/50 text-sm leading-relaxed">U wordt op de wachtlijst geplaatst. Zodra er een tuin vrijkomt, krijgt u bericht.</p>
                <div class="hidden md:block absolute top-10 -right-6 lg:-right-8 w-12 text-groen-500/30">
                    <svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
                </div>
            </div>
            <div class="text-center">
                <div class="w-20 h-20 mx-auto bg-groen-500/10 border border-groen-500/20 rounded-2xl flex items-center justify-center mb-6">
                    <span class="text-3xl font-display text-groen-400">03</span>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Start met tuinieren</h3>
                <p class="text-white/50 text-sm leading-relaxed">Ontvang uw tuinsleutel, maak kennis met uw buren en begin aan uw tuinavontuur!</p>
            </div>
        </div>
    </div>
</section>

<!-- MEDEDELINGEN -->
<?php if (!empty($bulletins)): ?>
<section class="py-20 lg:py-28 bg-creme">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-end justify-between mb-12">
            <div>
                <span class="text-xs font-semibold uppercase tracking-widest text-groen-600 mb-3 block">[ mededelingen ]</span>
                <h2 class="font-display text-3xl sm:text-4xl text-donker">Laatste nieuws</h2>
            </div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($bulletins as $i => $bulletin): ?>
            <div class="bg-white rounded-2xl p-6 border border-gray-100 hover:shadow-lg transition-shadow">
                <div class="flex items-center space-x-2 mb-4">
                    <?php if ($bulletin['type'] === 'belangrijk'): ?>
                    <span class="px-2.5 py-1 bg-red-50 text-red-600 text-xs font-semibold rounded-full">Belangrijk</span>
                    <?php elseif ($bulletin['type'] === 'waarschuwing'): ?>
                    <span class="px-2.5 py-1 bg-yellow-50 text-yellow-700 text-xs font-semibold rounded-full">Let op</span>
                    <?php else: ?>
                    <span class="px-2.5 py-1 bg-groen-50 text-groen-600 text-xs font-semibold rounded-full">Nieuws</span>
                    <?php endif; ?>
                    <span class="text-xs text-gray-400"><?= date('d-m-Y', strtotime($bulletin['created_at'])) ?></span>
                </div>
                <h3 class="text-lg font-bold text-donker mb-2"><?= e($bulletin['titel']) ?></h3>
                <p class="text-gray-500 text-sm leading-relaxed"><?= e(mb_strimwidth(strip_tags($bulletin['inhoud']), 0, 150, '...')) ?></p>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- AGENDA -->
<?php if (!empty($activiteiten)): ?>
<section class="py-20 lg:py-28 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-end justify-between mb-12">
            <div>
                <span class="text-xs font-semibold uppercase tracking-widest text-groen-600 mb-3 block">[ agenda ]</span>
                <h2 class="font-display text-3xl sm:text-4xl text-donker">Komende activiteiten</h2>
            </div>
            <a href="<?= url('/portaal/activiteiten') ?>" class="hidden sm:inline-flex items-center text-groen-600 font-semibold text-sm hover:text-groen-700">
                Alle activiteiten
                <svg class="ml-1 w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
            </a>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($activiteiten as $activiteit): ?>
            <div class="group bg-creme rounded-2xl p-6 hover:bg-donker transition-colors duration-300 cursor-default">
                <div class="flex items-start space-x-4">
                    <div class="bg-groen-500 rounded-xl p-3 text-center min-w-[64px] group-hover:bg-groen-400 transition-colors">
                        <span class="text-2xl font-display text-white leading-none block"><?= date('d', strtotime($activiteit['datum'])) ?></span>
                        <p class="text-xs text-groen-100 uppercase mt-0.5"><?= date('M', strtotime($activiteit['datum'])) ?></p>
                    </div>
                    <div>
                        <h3 class="font-bold text-donker group-hover:text-white transition-colors"><?= e($activiteit['titel']) ?></h3>
                        <p class="text-sm text-gray-500 group-hover:text-white/50 mt-1 transition-colors"><?= date('H:i', strtotime($activiteit['datum'])) ?> uur</p>
                        <?php if ($activiteit['locatie']): ?>
                        <p class="text-sm text-gray-400 group-hover:text-white/40 mt-1 transition-colors">📍 <?= e($activiteit['locatie']) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA BANNER -->
<section class="relative overflow-hidden grain">
    <div class="bg-groen-600">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 lg:py-24">
            <div class="flex flex-col lg:flex-row items-center justify-between gap-10">
                <div class="max-w-xl">
                    <h2 class="font-display text-3xl sm:text-4xl lg:text-5xl text-white leading-tight mb-4">
                        Wilt u ook genieten van uw eigen tuin?
                    </h2>
                    <p class="text-groen-100 text-lg">Neem vandaag nog contact met ons op en ontdek de mogelijkheden.</p>
                </div>
                <div class="flex flex-col sm:flex-row gap-4 shrink-0">
                    <a href="<?= url('/ik-wil-een-tuin') ?>" class="inline-flex items-center justify-center px-8 py-4 bg-white text-groen-700 font-bold rounded-xl hover:bg-groen-50 transition-colors text-lg shadow-lg">
                        🌱 Word lid
                    </a>
                    <a href="<?= url('/contact') ?>" class="inline-flex items-center justify-center px-8 py-4 border-2 border-white/30 text-white font-bold rounded-xl hover:bg-white/10 transition-colors text-lg">
                        Contact opnemen
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- SNELKOPPELINGEN -->
<section class="py-20 bg-creme">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 lg:gap-6">
            <a href="<?= url('/ik-wil-een-tuin') ?>" class="group bg-white rounded-2xl p-6 lg:p-8 border border-gray-100 hover:border-groen-300 hover:shadow-lg transition-all text-center">
                <div class="w-14 h-14 mx-auto bg-groen-50 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-groen-500 transition-colors">
                    <span class="text-2xl group-hover:scale-110 transition-transform inline-block">🌱</span>
                </div>
                <span class="text-sm font-semibold text-gray-700 group-hover:text-groen-700 transition-colors">Aspirant worden</span>
            </a>
            <a href="<?= url('/plattegrond') ?>" class="group bg-white rounded-2xl p-6 lg:p-8 border border-gray-100 hover:border-groen-300 hover:shadow-lg transition-all text-center">
                <div class="w-14 h-14 mx-auto bg-groen-50 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-groen-500 transition-colors">
                    <span class="text-2xl group-hover:scale-110 transition-transform inline-block">🗺️</span>
                </div>
                <span class="text-sm font-semibold text-gray-700 group-hover:text-groen-700 transition-colors">Plattegrond</span>
            </a>
            <a href="<?= url('/login') ?>" class="group bg-white rounded-2xl p-6 lg:p-8 border border-gray-100 hover:border-groen-300 hover:shadow-lg transition-all text-center">
                <div class="w-14 h-14 mx-auto bg-groen-50 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-groen-500 transition-colors">
                    <span class="text-2xl group-hover:scale-110 transition-transform inline-block">🔐</span>
                </div>
                <span class="text-sm font-semibold text-gray-700 group-hover:text-groen-700 transition-colors">Ledenportaal</span>
            </a>
            <a href="<?= url('/contact') ?>" class="group bg-white rounded-2xl p-6 lg:p-8 border border-gray-100 hover:border-groen-300 hover:shadow-lg transition-all text-center">
                <div class="w-14 h-14 mx-auto bg-groen-50 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-groen-500 transition-colors">
                    <span class="text-2xl group-hover:scale-110 transition-transform inline-block">📬</span>
                </div>
                <span class="text-sm font-semibold text-gray-700 group-hover:text-groen-700 transition-colors">Contact</span>
            </a>
        </div>
    </div>
</section>

<?php if ($sliderActief && count($sliderFotos) > 1): ?>
<script>
function heroSlider() {
    return {
        currentSlide: 0,
        totalSlides: <?= count($sliderFotos) ?>,
        startSlider() {
            setInterval(() => {
                this.currentSlide = (this.currentSlide + 1) % this.totalSlides;
            }, 5000);
        }
    }
}
</script>
<?php endif; ?>
