<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Menu beheer</h1>
    <button onclick="document.getElementById('menu-modal').classList.remove('hidden'); document.getElementById('menu-form').reset(); document.getElementById('menu-id').value = '';" 
            class="px-4 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition flex items-center space-x-2">
        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
        <span>Nieuw item</span>
    </button>
</div>

<div class="bg-white rounded-xl border border-gray-200">
    <div class="divide-y divide-gray-100">
        <?php foreach ($items as $item): ?>
        <div class="flex items-center justify-between px-6 py-3 hover:bg-gray-50 <?= $item['parent_id'] ? 'pl-14' : '' ?>">
            <div class="flex items-center space-x-3">
                <?php if (!$item['parent_id']): ?>
                <svg class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7"/></svg>
                <?php else: ?>
                <svg class="w-4 h-4 text-gray-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/></svg>
                <?php endif; ?>
                <div>
                    <span class="text-sm font-medium text-gray-900"><?= e($item['titel']) ?></span>
                    <span class="text-xs text-gray-400 ml-2"><?= e($item['url']) ?></span>
                </div>
                <?php if (!$item['actief']): ?>
                <span class="text-xs bg-gray-100 text-gray-500 px-2 py-0.5 rounded">Verborgen</span>
                <?php endif; ?>
            </div>
            <div class="flex items-center space-x-2">
                <button onclick="editItem(<?= htmlspecialchars(json_encode($item)) ?>)" 
                        class="p-1.5 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg">
                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                </button>
                <form method="POST" action="<?= url('/admin/menu/' . $item['id'] . '/delete') ?>" onsubmit="return confirm('Dit menu item verwijderen?')">
                    <?= csrf_field() ?>
                    <button type="submit" class="p-1.5 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg">
                        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                    </button>
                </form>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Menu Item Modal -->
<div id="menu-modal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-black/50">
    <div class="bg-white rounded-2xl w-full max-w-md mx-4 shadow-xl">
        <div class="flex items-center justify-between px-6 py-4 border-b">
            <h2 class="font-semibold text-gray-900" id="menu-modal-title">Menu item</h2>
            <button onclick="document.getElementById('menu-modal').classList.add('hidden')" class="text-gray-400 hover:text-gray-600">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <form id="menu-form" method="POST" action="<?= url('/admin/menu/save') ?>" class="p-6 space-y-4">
            <?= csrf_field() ?>
            <input type="hidden" name="id" id="menu-id" value="">
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Titel</label>
                <input type="text" name="titel" id="menu-titel" required class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">URL</label>
                <input type="text" name="url" id="menu-url" required placeholder="/over-ons" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                <p class="text-xs text-gray-400 mt-1">Gebruik # voor een dropdown zonder link</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Bovenliggend item</label>
                <select name="parent_id" id="menu-parent" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    <option value="">— Hoofdmenu —</option>
                    <?php foreach ($parents as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= e($p['titel']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Volgorde</label>
                <input type="number" name="volgorde" id="menu-volgorde" value="0" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
            </div>
            <div>
                <label class="flex items-center space-x-2 cursor-pointer">
                    <input type="checkbox" name="actief" id="menu-actief" checked class="w-4 h-4 text-groen-600 rounded">
                    <span class="text-sm text-gray-700">Zichtbaar in menu</span>
                </label>
            </div>
            <button type="submit" class="w-full py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition">
                Opslaan
            </button>
        </form>
    </div>
</div>

<script>
function editItem(item) {
    document.getElementById('menu-id').value = item.id;
    document.getElementById('menu-titel').value = item.titel;
    document.getElementById('menu-url').value = item.url;
    document.getElementById('menu-parent').value = item.parent_id || '';
    document.getElementById('menu-volgorde').value = item.volgorde;
    document.getElementById('menu-actief').checked = item.actief == 1;
    document.getElementById('menu-modal-title').textContent = 'Bewerk: ' + item.titel;
    document.getElementById('menu-modal').classList.remove('hidden');
}
</script>
