<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Herstelmeldingen</h1>
</div>
<div class="flex gap-2 mb-4">
    <a href="<?= url('/admin/inspecties/herstelmeldingen') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= !$currentStatus ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600' ?>">Alle</a>
    <a href="<?= url('/admin/inspecties/herstelmeldingen?status=ingediend') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'ingediend' ? 'bg-blue-500 text-white' : 'bg-white border text-gray-600' ?>">⏳ Te beoordelen</a>
    <a href="<?= url('/admin/inspecties/herstelmeldingen?status=goedgekeurd') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'goedgekeurd' ? 'bg-green-500 text-white' : 'bg-white border text-gray-600' ?>">✅ Goedgekeurd</a>
    <a href="<?= url('/admin/inspecties/herstelmeldingen?status=afgekeurd') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'afgekeurd' ? 'bg-red-500 text-white' : 'bg-white border text-gray-600' ?>">❌ Afgekeurd</a>
</div>
<div class="bg-white rounded-xl border overflow-hidden">
    <table class="w-full"><thead class="bg-gray-50 border-b"><tr>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tuin</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Ticket</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Gemeld door</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Status</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Datum</th>
        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase"></th>
    </tr></thead><tbody class="divide-y">
        <?php if (empty($meldingen)): ?><tr><td colspan="6" class="px-4 py-8 text-center text-gray-400">Geen herstelmeldingen</td></tr><?php endif; ?>
        <?php foreach ($meldingen as $m):
            $sKl = ['ingediend'=>'bg-blue-100 text-blue-700','goedgekeurd'=>'bg-green-100 text-green-700','afgekeurd'=>'bg-red-100 text-red-700'];
        ?>
        <tr class="hover:bg-gray-50">
            <td class="px-4 py-3 text-sm font-bold text-groen-700"><?= e($m['tuinnummer']) ?></td>
            <td class="px-4 py-3 text-sm"><?= e($m['ticket_titel']) ?></td>
            <td class="px-4 py-3 text-sm"><?= e($m['voornaam'] . ' ' . $m['achternaam']) ?></td>
            <td class="px-4 py-3"><span class="text-xs px-2 py-1 rounded <?= $sKl[$m['status']] ?? '' ?>"><?= ucfirst($m['status']) ?></span></td>
            <td class="px-4 py-3 text-sm text-gray-400"><?= date('d-m-Y H:i', strtotime($m['created_at'])) ?></td>
            <td class="px-4 py-3 text-right"><a href="<?= url('/admin/inspecties/herstelmeldingen/' . $m['id']) ?>" class="text-sm text-blue-600">Bekijk</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table>
</div>
