<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Controle punten beheer</h1>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-4">

        <?php foreach ($grouped as $catId => $cat): ?>
        <div class="bg-white rounded-xl border">
            <div class="px-6 py-3 border-b bg-gray-50 rounded-t-xl" x-data="{ editing: false }">
                <template x-if="!editing">
                    <div class="flex items-center justify-between">
                        <h2 class="font-semibold text-gray-900"><?= e($cat['naam']) ?></h2>
                        <div class="flex items-center space-x-2">
                            <button @click="editing = true" class="text-xs text-blue-600 hover:text-blue-800">Bewerk</button>
                            <form method="POST" action="<?= url('/admin/inspecties/checkpoints/categorie/delete') ?>" class="inline"
                                  onsubmit="return confirm('Categorie en alle bijbehorende punten verwijderen?')">
                                <?= csrf_field() ?>
                                <input type="hidden" name="id" value="<?= $catId ?>">
                                <button type="submit" class="text-xs text-red-500 hover:text-red-700">Verwijder</button>
                            </form>
                        </div>
                    </div>
                </template>
                <template x-if="editing">
                    <form method="POST" action="<?= url('/admin/inspecties/checkpoints/categorie') ?>" class="flex items-center space-x-2">
                        <?= csrf_field() ?>
                        <input type="hidden" name="id" value="<?= $catId ?>">
                        <input type="text" name="naam" value="<?= e($cat['naam']) ?>" class="flex-1 px-2 py-1 border rounded text-sm" required>
                        <input type="number" name="volgorde" value="<?= $cat['volgorde'] ?? 0 ?>" class="w-16 px-2 py-1 border rounded text-sm" placeholder="#">
                        <button type="submit" class="px-3 py-1 bg-groen-600 text-white text-xs rounded hover:bg-groen-700">Opslaan</button>
                        <button type="button" @click="editing = false" class="text-xs text-gray-500">Annuleer</button>
                    </form>
                </template>
            </div>
            <div class="divide-y">
                <?php foreach ($cat['punten'] as $p): ?>
                <div class="px-6 py-3" x-data="{ editing: false }">
                    <template x-if="!editing">
                        <div class="flex justify-between items-center">
                            <div class="flex-1">
                                <p class="text-sm font-medium <?= $p['actief'] ? '' : 'text-gray-400 line-through' ?>"><?= e($p['titel']) ?></p>
                                <?php if ($p['omschrijving']): ?><p class="text-xs text-gray-400 mt-0.5"><?= e($p['omschrijving']) ?></p><?php endif; ?>
                                <?php if ($p['reglement_referentie']): ?><p class="text-xs text-blue-400 mt-0.5">Ref: <?= e($p['reglement_referentie']) ?></p><?php endif; ?>
                            </div>
                            <div class="flex items-center space-x-3 shrink-0">
                                <span class="text-xs <?= $p['actief'] ? 'text-groen-600' : 'text-red-400' ?>"><?= $p['actief'] ? 'Actief' : 'Inactief' ?></span>
                                <button @click="editing = true" class="text-xs text-blue-600 hover:text-blue-800">Bewerk</button>
                                <form method="POST" action="<?= url('/admin/inspecties/checkpoints/delete') ?>" class="inline"
                                      onsubmit="return confirm('Controlepunt verwijderen?')">
                                    <?= csrf_field() ?>
                                    <input type="hidden" name="id" value="<?= $p['id'] ?>">
                                    <button type="submit" class="text-xs text-red-500 hover:text-red-700">Verwijder</button>
                                </form>
                            </div>
                        </div>
                    </template>
                    <template x-if="editing">
                        <form method="POST" action="<?= url('/admin/inspecties/checkpoints/save') ?>" class="space-y-2">
                            <?= csrf_field() ?>
                            <input type="hidden" name="id" value="<?= $p['id'] ?>">
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-2">
                                <input type="text" name="titel" value="<?= e($p['titel']) ?>" required class="px-2 py-1.5 border rounded text-sm w-full" placeholder="Titel">
                                <select name="categorie_id" class="px-2 py-1.5 border rounded text-sm w-full">
                                    <?php foreach ($categorieen as $c): ?>
                                    <option value="<?= $c['id'] ?>" <?= $c['id'] == $catId ? 'selected' : '' ?>><?= e($c['naam']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <input type="text" name="omschrijving" value="<?= e($p['omschrijving'] ?? '') ?>" class="px-2 py-1.5 border rounded text-sm w-full" placeholder="Omschrijving (optioneel)">
                            <div class="flex items-center space-x-3">
                                <input type="text" name="reglement_referentie" value="<?= e($p['reglement_referentie'] ?? '') ?>" class="px-2 py-1.5 border rounded text-sm flex-1" placeholder="Reglement referentie">
                                <label class="flex items-center space-x-1 shrink-0"><input type="checkbox" name="actief" value="1" <?= $p['actief'] ? 'checked' : '' ?> class="w-4 h-4"><span class="text-xs">Actief</span></label>
                            </div>
                            <div class="flex items-center space-x-2 pt-1">
                                <button type="submit" class="px-4 py-1.5 bg-groen-600 text-white text-xs rounded-lg hover:bg-groen-700">Opslaan</button>
                                <button type="button" @click="editing = false" class="px-3 py-1.5 text-xs text-gray-500 hover:text-gray-700">Annuleer</button>
                            </div>
                        </form>
                    </template>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>

        <?php if (empty($grouped)): ?>
        <div class="bg-white rounded-xl border p-8 text-center text-gray-400">Nog geen controle punten. Voeg eerst een categorie toe →</div>
        <?php endif; ?>
    </div>

    <div class="space-y-6">
        <form method="POST" action="<?= url('/admin/inspecties/checkpoints/categorie') ?>" class="bg-white rounded-xl border p-6 space-y-3">
            <?= csrf_field() ?>
            <h3 class="font-semibold text-gray-900">+ Nieuwe categorie</h3>
            <input type="text" name="naam" required placeholder="Naam categorie" class="w-full px-3 py-2 border rounded-lg text-sm">
            <input type="number" name="volgorde" placeholder="Volgorde (0, 1, 2...)" class="w-full px-3 py-2 border rounded-lg text-sm" value="0">
            <button class="w-full py-2 bg-groen-600 text-white text-sm rounded-lg hover:bg-groen-700">Categorie toevoegen</button>
        </form>
        <form method="POST" action="<?= url('/admin/inspecties/checkpoints/save') ?>" class="bg-white rounded-xl border p-6 space-y-3">
            <?= csrf_field() ?>
            <h3 class="font-semibold text-gray-900">+ Nieuw controlepunt</h3>
            <select name="categorie_id" required class="w-full px-3 py-2 border rounded-lg text-sm">
                <option value="">— Categorie —</option>
                <?php foreach ($categorieen as $c): ?><option value="<?= $c['id'] ?>"><?= e($c['naam']) ?></option><?php endforeach; ?>
            </select>
            <input type="text" name="titel" required placeholder="Titel" class="w-full px-3 py-2 border rounded-lg text-sm">
            <input type="text" name="omschrijving" placeholder="Omschrijving (optioneel)" class="w-full px-3 py-2 border rounded-lg text-sm">
            <input type="text" name="reglement_referentie" placeholder="Reglement referentie" class="w-full px-3 py-2 border rounded-lg text-sm">
            <label class="flex items-center space-x-2"><input type="checkbox" name="actief" value="1" checked class="w-4 h-4"><span class="text-sm">Actief</span></label>
            <button class="w-full py-2 bg-groen-600 text-white text-sm rounded-lg hover:bg-groen-700">Punt toevoegen</button>
        </form>
    </div>
</div>
