<div class="mb-8">
    <h1 class="text-2xl font-bold text-gray-900">Welkom terug, <?= e(explode(' ', $auth['user']['naam'])[0] ?? '') ?></h1>
    <p class="text-gray-500 mt-1">Hier is een overzicht van uw portaal.</p>
</div>

<!-- Summary Cards -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <!-- Open meldingen -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Open meldingen</p>
                <p class="text-3xl font-bold text-gray-900 mt-1"><?= count($meldingen) ?></p>
            </div>
            <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/></svg>
            </div>
        </div>
        <a href="<?= url('/portaal/meldingen') ?>" class="text-sm text-groen-600 hover:text-groen-700 mt-3 inline-block">Bekijk alles →</a>
    </div>

    <!-- Open aanvragen -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Open aanvragen</p>
                <p class="text-3xl font-bold text-gray-900 mt-1"><?= count($aanvragen) ?></p>
            </div>
            <div class="w-12 h-12 bg-purple-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
            </div>
        </div>
        <a href="<?= url('/portaal/vergunningen') ?>" class="text-sm text-groen-600 hover:text-groen-700 mt-3 inline-block">Bekijk alles →</a>
    </div>

    <!-- Betalingen -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Openstaand saldo</p>
                <p class="text-3xl font-bold <?= $openstaand_bedrag > 0 ? 'text-red-600' : 'text-groen-600' ?> mt-1">
                    &euro; <?= number_format($openstaand_bedrag, 2, ',', '.') ?>
                </p>
            </div>
            <div class="w-12 h-12 bg-yellow-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-yellow-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/></svg>
            </div>
        </div>
        <a href="<?= url('/portaal/betalingen') ?>" class="text-sm text-groen-600 hover:text-groen-700 mt-3 inline-block">Naar betalingen →</a>
    </div>

    <!-- Werkbeurten -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Werkbeurt saldo</p>
                <p class="text-3xl font-bold text-gray-900 mt-1"><?= number_format($werkbeurten_saldo, 1, ',', '.') ?> <span class="text-base font-normal text-gray-400">uur</span></p>
            </div>
            <div class="w-12 h-12 bg-groen-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-groen-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
        <a href="<?= url('/portaal/activiteiten') ?>" class="text-sm text-groen-600 hover:text-groen-700 mt-3 inline-block">Naar werkbeurten →</a>
    </div>
</div>

<!-- Two columns -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    
    <!-- Recent Meldingen -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100">
        <div class="px-6 py-4 border-b border-gray-100 flex justify-between items-center">
            <h2 class="font-semibold text-gray-900">Recente meldingen</h2>
            <a href="<?= url('/portaal/meldingen/nieuw') ?>" class="text-sm bg-groen-50 text-groen-700 px-3 py-1 rounded-full hover:bg-groen-100 transition">+ Nieuwe melding</a>
        </div>
        <div class="divide-y divide-gray-50">
            <?php if (empty($meldingen)): ?>
            <div class="px-6 py-8 text-center text-gray-400 text-sm">
                Geen openstaande meldingen
            </div>
            <?php else: ?>
                <?php foreach ($meldingen as $melding): ?>
                <a href="<?= url('/portaal/meldingen/' . $melding['id']) ?>" class="block px-6 py-4 hover:bg-gray-50 transition">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="font-medium text-gray-900 text-sm"><?= e($melding['onderwerp']) ?></p>
                            <p class="text-xs text-gray-500 mt-1"><?= e($melding['categorie']) ?></p>
                        </div>
                        <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium
                            <?php 
                            match($melding['status']) {
                                'nieuw' => print('bg-blue-100 text-blue-700'),
                                'in_behandeling' => print('bg-yellow-100 text-yellow-700'),
                                'aanvulling_gevraagd' => print('bg-orange-100 text-orange-700'),
                                default => print('bg-gray-100 text-gray-700'),
                            };
                            ?>">
                            <?= e(str_replace('_', ' ', ucfirst($melding['status']))) ?>
                        </span>
                    </div>
                </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Recent Aanvragen -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100">
        <div class="px-6 py-4 border-b border-gray-100 flex justify-between items-center">
            <h2 class="font-semibold text-gray-900">Aanvragen & Vergunningen</h2>
            <a href="<?= url('/portaal/vergunningen/nieuw') ?>" class="text-sm bg-groen-50 text-groen-700 px-3 py-1 rounded-full hover:bg-groen-100 transition">+ Nieuwe aanvraag</a>
        </div>
        <div class="divide-y divide-gray-50">
            <?php if (empty($aanvragen)): ?>
            <div class="px-6 py-8 text-center text-gray-400 text-sm">
                Geen openstaande aanvragen
            </div>
            <?php else: ?>
                <?php foreach ($aanvragen as $aanvraag): ?>
                <a href="<?= url('/portaal/vergunningen/' . $aanvraag['id']) ?>" class="block px-6 py-4 hover:bg-gray-50 transition">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="font-medium text-gray-900 text-sm">
                                <?= $aanvraag['type'] === 'parkeer' ? 'Parkeervergunning' : 'Bouwvergunning' ?>
                            </p>
                            <p class="text-xs text-gray-500 mt-1">
                                Ingediend op <?= date('d-m-Y', strtotime($aanvraag['created_at'])) ?>
                            </p>
                        </div>
                        <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium
                            <?php 
                            match($aanvraag['status']) {
                                'nieuw' => print('bg-blue-100 text-blue-700'),
                                'in_behandeling' => print('bg-yellow-100 text-yellow-700'),
                                'aanvulling_gevraagd' => print('bg-orange-100 text-orange-700'),
                                default => print('bg-gray-100 text-gray-700'),
                            };
                            ?>">
                            <?= e(str_replace('_', ' ', ucfirst($aanvraag['status']))) ?>
                        </span>
                    </div>
                </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
