<?php

namespace App\Models;

use App\Core\Database;

class HerstelMelding
{
    public static function find(int $id): ?array
    {
        $db = Database::getInstance();
        return $db->fetch(
            "SELECT hm.*, t.titel as ticket_titel, t.tuin_id, tu.tuinnummer,
                    u.voornaam, u.achternaam
             FROM herstel_meldingen hm
             JOIN inspectie_tickets t ON t.id = hm.ticket_id
             JOIN tuinen tu ON tu.id = hm.tuin_id
             JOIN users u ON u.id = hm.gemeld_door
             WHERE hm.id = ?", [$id]
        );
    }

    public static function getForTicket(int $ticketId): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT hm.*, u.voornaam, u.achternaam
             FROM herstel_meldingen hm
             JOIN users u ON u.id = hm.gemeld_door
             WHERE hm.ticket_id = ?
             ORDER BY hm.created_at DESC", [$ticketId]
        );
    }

    public static function getAll(string $status = ''): array
    {
        $db = Database::getInstance();
        $where = '1=1';
        $params = [];
        if ($status) { $where = "hm.status = ?"; $params[] = $status; }

        return $db->fetchAll(
            "SELECT hm.*, t.titel as ticket_titel, tu.tuinnummer,
                    u.voornaam, u.achternaam
             FROM herstel_meldingen hm
             JOIN inspectie_tickets t ON t.id = hm.ticket_id
             JOIN tuinen tu ON tu.id = hm.tuin_id
             JOIN users u ON u.id = hm.gemeld_door
             WHERE {$where}
             ORDER BY hm.created_at DESC", $params
        );
    }

    public static function create(array $data): int
    {
        $db = Database::getInstance();
        return $db->insert('herstel_meldingen', $data);
    }

    public static function update(int $id, array $data): bool
    {
        $db = Database::getInstance();
        return $db->update('herstel_meldingen', $data, 'id = ?', [$id]);
    }

    public static function getPhotos(int $id): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT * FROM fotos WHERE entiteit_type = 'herstelmelding' AND entiteit_id = ? ORDER BY created_at", [$id]
        );
    }

    public static function countPending(): int
    {
        $db = Database::getInstance();
        $row = $db->fetch("SELECT COUNT(*) as c FROM herstel_meldingen WHERE status = 'ingediend'");
        return (int)$row['c'];
    }
}
