<?php

namespace App\Middleware;

use App\Core\Session;

class CsrfMiddleware
{
    public function handle(): bool
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $token = $_POST['_csrf_token'] ?? '';
            if (!Session::validateCsrfToken($token)) {
                Session::flash('error', 'Ongeldig beveiligingstoken. Probeer opnieuw.');
                header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? '/'));
                exit;
            }
        }
        return true;
    }
}
