<div class="flex items-center space-x-3 mb-6">
    <a href="<?= url('/portaal/mijn-dossier') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
    </a>
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Herstelmelding indienen</h1>
        <p class="text-sm text-gray-500">Tuin <?= e($ticket['tuinnummer']) ?> — <?= e($ticket['titel']) ?></p>
    </div>
</div>

<div class="max-w-2xl">
    <div class="bg-orange-50 border border-orange-200 rounded-xl p-4 mb-6">
        <p class="text-sm text-orange-800"><strong>Wat wordt er verwacht?</strong><br>
        Voer het herstel uit, maak duidelijke foto's van het resultaat en beschrijf kort wat u heeft gedaan. Het bestuur beoordeelt uw melding.</p>
    </div>

    <form method="POST" action="<?= url('/portaal/herstel/' . $ticket['id'] . '/store') ?>" enctype="multipart/form-data">
        <?= csrf_field() ?>

        <div class="bg-white rounded-xl border p-6 space-y-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Beschrijving herstel *</label>
                <textarea name="omschrijving" rows="4" required class="w-full px-3 py-2 border rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none"
                          placeholder="Beschrijf wat u heeft hersteld..."></textarea>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Foto's (bewijs van herstel) *</label>
                <input type="file" name="photos[]" multiple accept="image/*" capture="environment"
                       class="w-full px-3 py-2 border rounded-lg text-sm file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:bg-groen-100 file:text-groen-700 hover:file:bg-groen-200">
                <p class="text-xs text-gray-400 mt-1">U kunt meerdere foto's selecteren. Gebruik bij voorkeur uw camera.</p>
            </div>

            <button type="submit" class="w-full py-3 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700 transition">
                📤 Herstelmelding indienen
            </button>
        </div>
    </form>
</div>
