<div class="flex items-center space-x-3 mb-6">
    <a href="<?= url('/admin/inspecties') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
    </a>
    <h1 class="text-2xl font-bold text-gray-900">Inspectie starten</h1>
</div>

<form method="POST" action="<?= url('/admin/inspecties/create') ?>" id="startForm">
    <?= csrf_field() ?>
    <div class="max-w-2xl space-y-6">
        <!-- Tuin selectie -->
        <div class="bg-white rounded-xl border p-6">
            <h2 class="font-semibold text-gray-900 mb-4">1. Selecteer tuin</h2>
            <select name="tuin_id" required class="w-full px-3 py-2 border rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                <option value="">— Kies een tuin —</option>
                <?php foreach ($tuinen as $t): ?>
                <option value="<?= $t['id'] ?>"><?= e($t['tuinnummer']) ?> <?= $t['voornaam'] ? '— ' . e($t['voornaam'] . ' ' . $t['achternaam']) : '' ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Scenario -->
        <div class="bg-white rounded-xl border p-6">
            <h2 class="font-semibold text-gray-900 mb-4">2. Situatie bij aankomst</h2>
            <div class="space-y-3">
                <label class="flex items-start space-x-3 p-3 border rounded-lg cursor-pointer hover:bg-groen-50 transition">
                    <input type="radio" name="scenario" value="aanwezig" class="mt-1" required>
                    <div>
                        <p class="font-medium text-gray-900">✅ Tuinder is aanwezig</p>
                        <p class="text-sm text-gray-500">Toestemming wordt gevraagd</p>
                    </div>
                </label>
                <label class="flex items-start space-x-3 p-3 border rounded-lg cursor-pointer hover:bg-groen-50 transition">
                    <input type="radio" name="scenario" value="afwezig">
                    <div>
                        <p class="font-medium text-gray-900">❌ Tuinder is niet aanwezig</p>
                        <p class="text-sm text-gray-500">Inspectie wordt uitgevoerd zonder tuinder</p>
                    </div>
                </label>
                <label class="flex items-start space-x-3 p-3 border rounded-lg cursor-pointer hover:bg-red-50 transition">
                    <input type="radio" name="scenario" value="weigert">
                    <div>
                        <p class="font-medium text-red-600">⛔ Tuinder weigert medewerking</p>
                        <p class="text-sm text-gray-500">Direct rood ticket — inspectie wordt niet uitgevoerd</p>
                    </div>
                </label>
            </div>
        </div>

        <!-- Toestemming (alleen bij aanwezig) -->
        <div class="bg-white rounded-xl border p-6 hidden" id="toestemmingBlock">
            <h2 class="font-semibold text-gray-900 mb-4">3. Toestemming</h2>
            <label class="flex items-center space-x-2 mb-3 cursor-pointer">
                <input type="checkbox" name="toestemming" value="1" class="w-4 h-4 text-groen-600 rounded">
                <span class="text-sm text-gray-700">Tuinder geeft toestemming voor inspectie</span>
            </label>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Naam tuinder</label>
                <input type="text" name="toestemming_naam" class="w-full px-3 py-2 border rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none" placeholder="Volledige naam">
            </div>
        </div>

        <!-- Weigering (alleen bij weigert) -->
        <div class="bg-white rounded-xl border border-red-200 p-6 hidden" id="weigeringBlock">
            <h2 class="font-semibold text-red-600 mb-4">⛔ Weigering medewerking</h2>
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Naam tuinder (indien bekend)</label>
                    <input type="text" name="weigering_naam" class="w-full px-3 py-2 border rounded-lg text-sm">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Reden weigering *</label>
                    <input type="text" name="weigering_reden" class="w-full px-3 py-2 border rounded-lg text-sm" placeholder="Bijv: Verbale weigering, deur niet geopend">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Toelichting *</label>
                    <textarea name="weigering_toelichting" rows="3" class="w-full px-3 py-2 border rounded-lg text-sm" placeholder="Beschrijf de situatie..."></textarea>
                </div>
            </div>
        </div>

        <button type="submit" class="w-full py-3 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700 transition">
            Inspectie starten →
        </button>
    </div>
</form>

<script>
document.querySelectorAll('input[name="scenario"]').forEach(radio => {
    radio.addEventListener('change', function() {
        document.getElementById('toestemmingBlock').classList.toggle('hidden', this.value !== 'aanwezig');
        document.getElementById('weigeringBlock').classList.toggle('hidden', this.value !== 'weigert');
    });
});
</script>
