<h1 class="text-2xl font-bold text-gray-900 mb-6">Dashboard</h1>

<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
    <a href="<?= url('/admin/paginas') ?>" class="bg-white rounded-xl border border-gray-200 p-6 hover:shadow-md hover:border-groen-200 transition">
        <div class="flex items-center justify-between mb-4">
            <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
            </div>
            <span class="text-3xl font-bold text-gray-900"><?= count($pages) ?></span>
        </div>
        <p class="text-sm font-medium text-gray-600">Pagina's</p>
        <p class="text-xs text-gray-400 mt-1">Teksten en foto's bewerken</p>
    </a>

    <a href="<?= url('/admin/media') ?>" class="bg-white rounded-xl border border-gray-200 p-6 hover:shadow-md hover:border-groen-200 transition">
        <div class="flex items-center justify-between mb-4">
            <div class="w-12 h-12 bg-purple-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
            </div>
            <span class="text-3xl font-bold text-gray-900"><?= $mediaCount ?></span>
        </div>
        <p class="text-sm font-medium text-gray-600">Media bestanden</p>
        <p class="text-xs text-gray-400 mt-1">Foto's en documenten</p>
    </a>

    <a href="<?= url('/admin/menu') ?>" class="bg-white rounded-xl border border-gray-200 p-6 hover:shadow-md hover:border-groen-200 transition">
        <div class="flex items-center justify-between mb-4">
            <div class="w-12 h-12 bg-amber-50 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-amber-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7"/></svg>
            </div>
        </div>
        <p class="text-sm font-medium text-gray-600">Menu beheer</p>
        <p class="text-xs text-gray-400 mt-1">Navigatie aanpassen</p>
    </a>
</div>

<div class="bg-white rounded-xl border border-gray-200">
    <div class="px-6 py-4 border-b border-gray-100">
        <h2 class="font-semibold text-gray-900">Snel bewerken</h2>
    </div>
    <div class="divide-y divide-gray-100">
        <?php 
        $labels = [
            'home' => ['Homepage', 'Hero tekst, bulletins, afbeeldingen'],
            'over-ons' => ['Over ons', 'Wie zijn wij, waarden'],
            'bestuur' => ['Bestuur', 'Bestuursleden en functies'],
            'commissies' => ['Commissies', 'Commissie informatie'],
            'faciliteiten' => ['Faciliteiten', 'Beschikbare voorzieningen'],
            'contact' => ['Contact', 'Contactgegevens en bereikbaarheid'],
            'aspirant-info' => ['Word lid', 'Aspirant procedure'],
        ];
        foreach ($labels as $slug => $info): ?>
        <a href="<?= url('/admin/paginas/' . $slug) ?>" class="flex items-center justify-between px-6 py-4 hover:bg-gray-50 transition">
            <div>
                <p class="font-medium text-gray-900"><?= $info[0] ?></p>
                <p class="text-sm text-gray-500"><?= $info[1] ?></p>
            </div>
            <svg class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
        </a>
        <?php endforeach; ?>
    </div>
</div>
