<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Tuinbeheer</h1>
        <p class="text-sm text-gray-500 mt-1"><?= $totaal ?> tuinen · <?= $bezet ?> bezet · <?= $beschikbaar ?> beschikbaar</p>
    </div>
    <a href="<?= url('/admin/tuinen/nieuw') ?>" class="px-4 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition flex items-center space-x-2">
        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
        <span>Nieuwe tuin</span>
    </a>
</div>

<!-- Filter -->
<div class="flex gap-2 mb-6">
    <a href="<?= url('/admin/tuinen') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= !$currentStatus ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Alle</a>
    <a href="<?= url('/admin/tuinen?status=bezet') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'bezet' ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Bezet</a>
    <a href="<?= url('/admin/tuinen?status=beschikbaar') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'beschikbaar' ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Beschikbaar</a>
    <a href="<?= url('/admin/tuinen?status=onderhoud') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'onderhoud' ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">Onderhoud</a>
</div>

<div class="bg-white rounded-xl border border-gray-200 overflow-hidden">
    <table class="w-full">
        <thead class="bg-gray-50 border-b border-gray-200">
            <tr>
                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Nr</th>
                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Type</th>
                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Opp.</th>
                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Huurder</th>
                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Status</th>
                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Voorz.</th>
                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase">Acties</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            <?php if (empty($tuinen)): ?>
            <tr><td colspan="7" class="px-4 py-8 text-center text-gray-400">Geen tuinen gevonden</td></tr>
            <?php endif; ?>
            <?php foreach ($tuinen as $t): ?>
            <tr class="hover:bg-gray-50">
                <td class="px-4 py-3 text-sm font-bold text-groen-700"><?= e($t['tuinnummer']) ?></td>
                <td class="px-4 py-3 text-sm text-gray-600"><?= e(ucfirst($t['type'])) ?></td>
                <td class="px-4 py-3 text-sm text-gray-600"><?= $t['oppervlakte'] ? $t['oppervlakte'] . ' m²' : '—' ?></td>
                <td class="px-4 py-3 text-sm">
                    <?php if ($t['voornaam']): ?>
                    <a href="<?= url('/admin/leden/' . ($t['user_id'] ?? '')) ?>" class="text-groen-600 hover:text-groen-700">
                        <?= e($t['voornaam']) ?> <?= e($t['tussenvoegsel'] ?? '') ?> <?= e($t['achternaam']) ?>
                    </a>
                    <?php else: ?>
                    <span class="text-gray-400">—</span>
                    <?php endif; ?>
                </td>
                <td class="px-4 py-3">
                    <?php
                    $statusKleuren = ['bezet' => 'bg-blue-100 text-blue-700', 'beschikbaar' => 'bg-groen-100 text-groen-700', 'onderhoud' => 'bg-yellow-100 text-yellow-700', 'gereserveerd' => 'bg-purple-100 text-purple-700'];
                    $kleur = $statusKleuren[$t['status']] ?? 'bg-gray-100 text-gray-600';
                    ?>
                    <span class="text-xs px-2 py-1 rounded-full <?= $kleur ?>"><?= e(ucfirst($t['status'])) ?></span>
                </td>
                <td class="px-4 py-3 text-sm text-gray-500">
                    <?= $t['heeft_water'] ? '💧' : '' ?><?= $t['heeft_elektra'] ? '⚡' : '' ?>
                </td>
                <td class="px-4 py-3 text-right flex items-center justify-end space-x-2">
                    <a href="<?= url('/admin/tuinen/' . $t['id']) ?>" class="text-sm text-blue-600 hover:text-blue-800">Bewerken</a>
                    <form method="POST" action="<?= url('/admin/tuinen/' . $t['id'] . '/delete') ?>" onsubmit="return confirm('Tuin verwijderen?')">
                        <?= csrf_field() ?>
                        <button class="text-sm text-red-500 hover:text-red-700">Verwijderen</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
