<?php $isEdit = !empty($lid); ?>

<div class="flex items-center space-x-3 mb-6">
    <a href="<?= url($isEdit ? '/admin/leden/' . $lid['id'] : '/admin/leden') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
    </a>
    <h1 class="text-2xl font-bold text-gray-900"><?= e($title) ?></h1>
</div>

<form method="POST" action="<?= url($isEdit ? '/admin/leden/' . $lid['id'] : '/admin/leden') ?>">
    <?= csrf_field() ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 space-y-6">

            <!-- Persoonsgegevens -->
            <div class="bg-white rounded-xl border border-gray-200">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                    <h2 class="font-semibold text-gray-900">Persoonsgegevens</h2>
                </div>
                <div class="p-6 grid grid-cols-1 sm:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Voornaam *</label>
                        <input type="text" name="voornaam" value="<?= e($lid['voornaam'] ?? '') ?>" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Tussenvoegsel</label>
                        <input type="text" name="tussenvoegsel" value="<?= e($lid['tussenvoegsel'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Achternaam *</label>
                        <input type="text" name="achternaam" value="<?= e($lid['achternaam'] ?? '') ?>" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">E-mail *</label>
                        <input type="email" name="email" value="<?= e($lid['email'] ?? '') ?>" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Telefoon</label>
                        <input type="tel" name="telefoon" value="<?= e($lid['telefoon'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Mobiel</label>
                        <input type="tel" name="mobiel" value="<?= e($lid['mobiel'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Geboortedatum</label>
                        <input type="date" name="geboortedatum" value="<?= e($lid['geboortedatum'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Kenteken</label>
                        <input type="text" name="kenteken" value="<?= e($lid['kenteken'] ?? '') ?>" placeholder="AB-123-CD"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                </div>
            </div>

            <!-- Adres -->
            <div class="bg-white rounded-xl border border-gray-200">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                    <h2 class="font-semibold text-gray-900">Adres</h2>
                </div>
                <div class="p-6 grid grid-cols-1 sm:grid-cols-4 gap-4">
                    <div class="sm:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Straat</label>
                        <input type="text" name="straat" value="<?= e($lid['straat'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Huisnr</label>
                        <input type="text" name="huisnummer" value="<?= e($lid['huisnummer'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Postcode</label>
                        <input type="text" name="postcode" value="<?= e($lid['postcode'] ?? '') ?>" placeholder="1234 AB"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div class="sm:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Woonplaats</label>
                        <input type="text" name="woonplaats" value="<?= e($lid['woonplaats'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                </div>
            </div>

            <!-- Partner -->
            <div class="bg-white rounded-xl border border-gray-200">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                    <h2 class="font-semibold text-gray-900">Partner</h2>
                </div>
                <div class="p-6 grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Voornaam</label>
                        <input type="text" name="partner_voornaam" value="<?= e($lid['partner_voornaam'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Achternaam</label>
                        <input type="text" name="partner_achternaam" value="<?= e($lid['partner_achternaam'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Telefoon</label>
                        <input type="tel" name="partner_telefoon" value="<?= e($lid['partner_telefoon'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">E-mail</label>
                        <input type="email" name="partner_email" value="<?= e($lid['partner_email'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                </div>
            </div>

            <!-- Noodcontact -->
            <div class="bg-white rounded-xl border border-gray-200">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                    <h2 class="font-semibold text-gray-900">Noodcontact</h2>
                </div>
                <div class="p-6 grid grid-cols-1 sm:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Naam</label>
                        <input type="text" name="noodcontact_naam" value="<?= e($lid['noodcontact_naam'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Telefoon</label>
                        <input type="tel" name="noodcontact_telefoon" value="<?= e($lid['noodcontact_telefoon'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Relatie</label>
                        <input type="text" name="noodcontact_relatie" value="<?= e($lid['noodcontact_relatie'] ?? '') ?>" placeholder="Partner, ouder, etc."
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Account -->
            <div class="bg-white rounded-xl border border-gray-200 p-6 space-y-4">
                <h3 class="font-semibold text-gray-900">Account</h3>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Lidnummer</label>
                    <input type="text" name="lidnummer" value="<?= e($lid['lidnummer'] ?? '') ?>" placeholder="Auto-genereer"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    <p class="text-xs text-gray-400 mt-1">Laat leeg voor automatisch</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Rol</label>
                    <select name="role_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                        <?php foreach ($roles as $role): ?>
                        <option value="<?= $role['id'] ?>" <?= ($lid['role_id'] ?? 6) == $role['id'] ? 'selected' : '' ?>><?= e($role['naam']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1"><?= $isEdit ? 'Nieuw wachtwoord' : 'Wachtwoord' ?></label>
                    <input type="password" name="wachtwoord" <?= $isEdit ? '' : '' ?>
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    <?php if ($isEdit): ?>
                    <p class="text-xs text-gray-400 mt-1">Laat leeg om niet te wijzigen</p>
                    <?php else: ?>
                    <p class="text-xs text-gray-400 mt-1">Laat leeg voor automatisch</p>
                    <?php endif; ?>
                </div>
                <div>
                    <label class="flex items-center space-x-2 cursor-pointer">
                        <input type="hidden" name="actief" value="0">
                        <input type="checkbox" name="actief" value="1" <?= ($lid['actief'] ?? 1) ? 'checked' : '' ?> class="w-4 h-4 text-groen-600 rounded">
                        <span class="text-sm text-gray-700">Account actief</span>
                    </label>
                </div>
            </div>

            <!-- Tuin -->
            <div class="bg-white rounded-xl border border-gray-200 p-6 space-y-4">
                <h3 class="font-semibold text-gray-900">Tuin toewijzen</h3>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Tuin</label>
                    <select name="tuin_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                        <option value="">— Geen tuin —</option>
                        <?php foreach ($tuinen as $t): ?>
                        <option value="<?= $t['id'] ?>" <?= ($huidigeTuin && $huidigeTuin['id'] == $t['id']) ? 'selected' : '' ?>>
                            Tuin <?= e($t['tuinnummer']) ?> <?= $t['oppervlakte'] ? '(' . $t['oppervlakte'] . ' m²)' : '' ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Startdatum</label>
                    <input type="date" name="tuin_start_datum" value="<?= e($huidigeTuin['start_datum'] ?? date('Y-m-d')) ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                </div>
            </div>

            <!-- Opslaan -->
            <button type="submit" class="w-full py-3 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700 transition">
                <?= $isEdit ? 'Wijzigingen opslaan' : 'Lid aanmaken' ?>
            </button>
        </div>
    </div>
</form>
