<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Tickets</h1>
</div>
<div class="flex gap-2 mb-4">
    <a href="<?= url('/admin/inspecties/tickets') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= !$currentStatus ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600' ?>">Alle</a>
    <a href="<?= url('/admin/inspecties/tickets?status=oranje') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'oranje' ? 'bg-orange-500 text-white' : 'bg-white border text-gray-600' ?>">Oranje</a>
    <a href="<?= url('/admin/inspecties/tickets?status=rood') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'rood' ? 'bg-red-500 text-white' : 'bg-white border text-gray-600' ?>">Rood</a>
    <a href="<?= url('/admin/inspecties/tickets?status=groen') ?>" class="px-3 py-1.5 text-sm rounded-lg <?= $currentStatus === 'groen' ? 'bg-green-500 text-white' : 'bg-white border text-gray-600' ?>">Groen</a>
</div>
<div class="bg-white rounded-xl border overflow-hidden">
    <table class="w-full"><thead class="bg-gray-50 border-b"><tr>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tuin</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Punt</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Status</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Deadline</th>
        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Aangemaakt</th>
    </tr></thead><tbody class="divide-y">
        <?php if (empty($tickets)): ?><tr><td colspan="5" class="px-4 py-8 text-center text-gray-400">Geen tickets</td></tr><?php endif; ?>
        <?php foreach ($tickets as $t):
            $overdue = $t['status'] !== 'groen' && $t['deadline'] && $t['deadline'] < date('Y-m-d');
            $kl = ['groen'=>'bg-green-100 text-green-700','oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700'];
        ?>
        <tr class="hover:bg-gray-50 <?= $overdue ? 'bg-red-50' : '' ?>">
            <td class="px-4 py-3 text-sm font-bold text-groen-700"><a href="<?= url('/admin/inspecties/dossier/' . $t['tuin_id']) ?>"><?= e($t['tuinnummer']) ?></a></td>
            <td class="px-4 py-3 text-sm"><?= e($t['titel']) ?></td>
            <td class="px-4 py-3"><span class="text-xs px-2 py-1 rounded <?= $kl[$t['status']] ?? '' ?>"><?= ucfirst($t['status']) ?></span></td>
            <td class="px-4 py-3 text-sm <?= $overdue ? 'text-red-600 font-bold' : 'text-gray-500' ?>"><?= $t['deadline'] ? date('d-m-Y', strtotime($t['deadline'])) : '—' ?><?= $overdue ? ' ⚠️' : '' ?></td>
            <td class="px-4 py-3 text-sm text-gray-400"><?= date('d-m-Y', strtotime($t['created_at'])) ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table>
</div>
