<?php

namespace App\Middleware;

use App\Core\Auth;
use App\Core\Session;

class AuthMiddleware
{
    public function handle(): bool
    {
        if (!Auth::check()) {
            Session::flash('error', 'U moet ingelogd zijn om deze pagina te bekijken.');
            $basePath = \App\Core\View::basePath();
            header('Location: ' . $basePath . '/login');
            exit;
        }
        return true;
    }
}
