<?php
/**
 * VTV De Beukhoeve - Database Migratie Runner
 * 
 * Upload naar beukhoeve/ en bezoek in de browser.
 * Voert nieuwe migraties uit op de database.
 * VERWIJDER DIT BESTAND NA GEBRUIK!
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

define('BASE_PATH', __DIR__);

// Laad .env
$envFile = BASE_PATH . '/.env';
if (!file_exists($envFile)) {
    die('<h2 style="color:red;">❌ .env bestand niet gevonden!</h2>');
}

$lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$env = [];
foreach ($lines as $line) {
    if (str_starts_with(trim($line), '#')) continue;
    if (str_contains($line, '=')) {
        [$key, $value] = explode('=', $line, 2);
        $env[trim($key)] = trim($value);
    }
}

echo '<html><head><style>body{font-family:system-ui;max-width:700px;margin:40px auto;padding:0 20px}
.ok{color:#16a34a}.fail{color:#dc2626}pre{background:#f3f4f6;padding:12px;border-radius:8px;font-size:13px;overflow-x:auto;white-space:pre-wrap}</style></head><body>';
echo '<h1>🔄 Database Migratie</h1>';

try {
    $pdo = new PDO(
        "mysql:host={$env['DB_HOST']};port={$env['DB_PORT']};dbname={$env['DB_NAME']};charset=utf8mb4",
        $env['DB_USER'],
        $env['DB_PASS'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    echo '<p class="ok">✅ Database verbinding OK</p>';

    // Zoek alle migratie bestanden
    $migrationDir = BASE_PATH . '/database/migrations/';
    $files = glob($migrationDir . '*.sql');
    sort($files);

    if (empty($files)) {
        echo '<p class="fail">Geen migratie bestanden gevonden.</p>';
    } else {
        // Voer alleen uit als bevestigd
        if (isset($_POST['run'])) {
            $selected = $_POST['migrations'] ?? [];
            foreach ($files as $file) {
                $name = basename($file);
                if (!in_array($name, $selected)) continue;
                
                echo '<h3>📄 ' . htmlspecialchars($name) . '</h3>';
                try {
                    $sql = file_get_contents($file);
                    $pdo->exec($sql);
                    echo '<p class="ok">✅ Succesvol uitgevoerd!</p>';
                } catch (PDOException $e) {
                    $msg = $e->getMessage();
                    // "Table already exists" is ok
                    if (str_contains($msg, 'already exists')) {
                        echo '<p class="ok">⏭️ Tabellen bestaan al (overgeslagen)</p>';
                    } else {
                        echo '<p class="fail">❌ Fout: ' . htmlspecialchars($msg) . '</p>';
                    }
                }
            }

            // Tel tabellen
            $count = $pdo->query("SELECT COUNT(*) FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$env['DB_NAME']}'")->fetchColumn();
            echo '<hr><p class="ok"><strong>✅ Klaar!</strong> Database heeft nu ' . $count . ' tabellen.</p>';
            echo '<p><a href="' . dirname($_SERVER['SCRIPT_NAME']) . '/admin" style="color:#16a34a;font-weight:bold;">→ Ga naar beheerpaneel</a></p>';
            echo '<p style="color:#999;font-size:13px;">Vergeet niet dit bestand te verwijderen!</p>';
        } else {
            // Toon beschikbare migraties
            echo '<form method="POST"><p>Selecteer de migraties om uit te voeren:</p>';
            foreach ($files as $file) {
                $name = basename($file);
                $size = number_format(filesize($file));
                $checked = !str_contains($name, '001_') ? 'checked' : ''; // Skip initial if probably done
                echo "<label style='display:block;padding:8px;margin:4px 0;background:#f9fafb;border-radius:8px;cursor:pointer'>";
                echo "<input type='checkbox' name='migrations[]' value='{$name}' {$checked}> ";
                echo "<strong>{$name}</strong> <span style='color:#999'>({$size} bytes)</span>";
                echo "</label>";
            }
            echo '<button type="submit" name="run" value="1" style="margin-top:16px;padding:10px 24px;background:#16a34a;color:white;border:none;border-radius:8px;cursor:pointer;font-size:14px">Migraties uitvoeren</button>';
            echo '</form>';
        }
    }
} catch (PDOException $e) {
    echo '<p class="fail">❌ Database fout: ' . htmlspecialchars($e->getMessage()) . '</p>';
}

echo '</body></html>';
