<?php $statusKleuren = ['groen'=>'bg-green-100 text-green-700','oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700']; ?>

<div class="flex items-center justify-between mb-6">
    <div class="flex items-center space-x-3">
        <a href="<?= url('/portaal/inspecties') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Inspectie #<?= $inspectie['id'] ?> — Tuin <?= e($inspectie['tuinnummer']) ?></h1>
            <p class="text-sm text-gray-500"><?= date('d-m-Y H:i', strtotime($inspectie['gestart_op'])) ?></p>
        </div>
    </div>
    <?php if ($inspectie['eindstatus']): ?>
    <span class="px-4 py-2 rounded-lg text-sm font-bold <?= $statusKleuren[$inspectie['eindstatus']] ?? '' ?>"><?= ucfirst($inspectie['eindstatus']) ?></span>
    <?php endif; ?>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-4">
        <div class="bg-white rounded-xl border p-6 grid grid-cols-2 sm:grid-cols-4 gap-4 text-sm">
            <div><span class="text-gray-500">Status</span><br><strong><?= ucfirst($inspectie['status']) ?></strong></div>
            <div><span class="text-gray-500">Tuinder</span><br><?= $inspectie['tuinder_aanwezig'] ? '✅ Aanwezig' : '❌ Afwezig' ?></div>
            <div><span class="text-gray-500">Toestemming</span><br><?= $inspectie['toestemming'] ? '✅ ' . e($inspectie['toestemming_naam']) : '—' ?></div>
            <div><span class="text-gray-500">Afgerond</span><br><?= $inspectie['afgerond_op'] ? date('d-m-Y H:i', strtotime($inspectie['afgerond_op'])) : '—' ?></div>
        </div>

        <?php if ($inspectie['weigert_medewerking']): ?>
        <div class="bg-red-50 border border-red-200 rounded-xl p-6">
            <h3 class="font-bold text-red-600 mb-2">⛔ Weigering medewerking</h3>
            <p class="text-sm whitespace-pre-line"><?= e($inspectie['algemeen_rapport']) ?></p>
        </div>
        <?php endif; ?>

        <?php if (!empty($items)):
            $grouped = [];
            foreach ($items as $item) { $grouped[$item['categorie_id']]['naam'] = $item['categorie_naam']; $grouped[$item['categorie_id']]['items'][] = $item; }
        ?>
        <?php foreach ($grouped as $cat): ?>
        <div class="bg-white rounded-xl border">
            <div class="px-6 py-3 border-b bg-gray-50 rounded-t-xl"><h3 class="font-semibold text-sm"><?= e($cat['naam']) ?></h3></div>
            <div class="divide-y">
                <?php foreach ($cat['items'] as $item): ?>
                <div class="px-6 py-3 flex items-center justify-between">
                    <div>
                        <span class="text-sm"><?= e($item['punt_titel']) ?></span>
                        <?php if ($item['opmerking']): ?><p class="text-xs text-gray-400"><?= e($item['opmerking']) ?></p><?php endif; ?>
                    </div>
                    <?php if ($item['status'] === 'ok'): ?><span class="text-xs px-2 py-1 rounded bg-green-100 text-green-700">✓ OK</span>
                    <?php elseif ($item['status'] === 'niet_ok'): ?><span class="text-xs px-2 py-1 rounded bg-red-100 text-red-700">✗ Niet OK</span>
                    <?php else: ?><span class="text-xs px-2 py-1 rounded bg-gray-100 text-gray-500">N.v.t.</span><?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; endif; ?>

        <?php if ($inspectie['algemeen_rapport'] && !$inspectie['weigert_medewerking']): ?>
        <div class="bg-white rounded-xl border p-6">
            <h3 class="font-semibold mb-2">Algemeen rapport</h3>
            <p class="text-sm text-gray-600 whitespace-pre-line"><?= e($inspectie['algemeen_rapport']) ?></p>
        </div>
        <?php endif; ?>
    </div>

    <div>
        <div class="bg-white rounded-xl border p-6">
            <h3 class="font-semibold mb-3">Tickets (<?= count($tickets) ?>)</h3>
            <?php if (empty($tickets)): ?><p class="text-sm text-gray-400">Geen tickets</p>
            <?php else: ?>
            <div class="space-y-2">
                <?php foreach ($tickets as $t):
                    $tkKleur = ['groen'=>'border-green-400','oranje'=>'border-orange-400','rood'=>'border-red-400'][$t['status']] ?? '';
                ?>
                <div class="border-l-4 <?= $tkKleur ?> pl-3 py-1">
                    <p class="text-sm font-medium"><?= e($t['titel']) ?></p>
                    <p class="text-xs text-gray-400">Deadline: <?= $t['deadline'] ? date('d-m-Y', strtotime($t['deadline'])) : '—' ?></p>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
