<?php $isEdit = !empty($tuin); ?>

<div class="flex items-center space-x-3 mb-6">
    <a href="<?= url('/admin/tuinen') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
    </a>
    <h1 class="text-2xl font-bold text-gray-900"><?= e($title) ?></h1>
</div>

<form method="POST" action="<?= url('/admin/tuinen/save') ?>">
    <?= csrf_field() ?>
    <input type="hidden" name="id" value="<?= $tuin['id'] ?? 0 ?>">

    <div class="max-w-2xl">
        <div class="bg-white rounded-xl border border-gray-200">
            <div class="p-6 space-y-4">
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Tuinnummer *</label>
                        <input type="text" name="tuinnummer" value="<?= e($tuin['tuinnummer'] ?? '') ?>" required placeholder="Bijv: 42"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Oppervlakte (m²)</label>
                        <input type="number" step="0.01" name="oppervlakte" value="<?= e($tuin['oppervlakte'] ?? '') ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Type</label>
                        <select name="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                            <option value="standaard" <?= ($tuin['type'] ?? '') === 'standaard' ? 'selected' : '' ?>>Standaard</option>
                            <option value="groot" <?= ($tuin['type'] ?? '') === 'groot' ? 'selected' : '' ?>>Groot</option>
                            <option value="hoek" <?= ($tuin['type'] ?? '') === 'hoek' ? 'selected' : '' ?>>Hoek</option>
                            <option value="anders" <?= ($tuin['type'] ?? '') === 'anders' ? 'selected' : '' ?>>Anders</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                            <option value="beschikbaar" <?= ($tuin['status'] ?? 'beschikbaar') === 'beschikbaar' ? 'selected' : '' ?>>Beschikbaar</option>
                            <option value="bezet" <?= ($tuin['status'] ?? '') === 'bezet' ? 'selected' : '' ?>>Bezet</option>
                            <option value="onderhoud" <?= ($tuin['status'] ?? '') === 'onderhoud' ? 'selected' : '' ?>>Onderhoud</option>
                            <option value="gereserveerd" <?= ($tuin['status'] ?? '') === 'gereserveerd' ? 'selected' : '' ?>>Gereserveerd</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Locatie omschrijving</label>
                    <input type="text" name="locatie_omschrijving" value="<?= e($tuin['locatie_omschrijving'] ?? '') ?>" placeholder="Bijv: Pad A, naast het tuinhuis"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                </div>
                <div class="flex space-x-6">
                    <label class="flex items-center space-x-2 cursor-pointer">
                        <input type="checkbox" name="heeft_water" value="1" <?= ($tuin['heeft_water'] ?? 1) ? 'checked' : '' ?> class="w-4 h-4 text-groen-600 rounded">
                        <span class="text-sm text-gray-700">💧 Water</span>
                    </label>
                    <label class="flex items-center space-x-2 cursor-pointer">
                        <input type="checkbox" name="heeft_elektra" value="1" <?= ($tuin['heeft_elektra'] ?? 0) ? 'checked' : '' ?> class="w-4 h-4 text-groen-600 rounded">
                        <span class="text-sm text-gray-700">⚡ Elektra</span>
                    </label>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Notities</label>
                    <textarea name="notities" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none"><?= e($tuin['notities'] ?? '') ?></textarea>
                </div>
            </div>
        </div>

        <div class="flex items-center justify-between mt-6">
            <a href="<?= url('/admin/tuinen') ?>" class="text-sm text-gray-500 hover:text-gray-700">Annuleren</a>
            <button type="submit" class="px-6 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700">
                <?= $isEdit ? 'Opslaan' : 'Tuin aanmaken' ?>
            </button>
        </div>
    </div>
</form>
