<?php

namespace App\Models;

use App\Core\Database;

class Tuin
{
    public static function find(int $id): ?array
    {
        $db = Database::getInstance();
        return $db->fetch("SELECT * FROM tuinen WHERE id = ?", [$id]);
    }

    public static function getAll(string $status = ''): array
    {
        $db = Database::getInstance();
        $sql = "SELECT t.*, 
                       u.voornaam, u.achternaam, u.tussenvoegsel, u.lidnummer,
                       lt.start_datum as huurder_sinds
                FROM tuinen t
                LEFT JOIN lid_tuin lt ON lt.tuin_id = t.id AND lt.actief = 1
                LEFT JOIN users u ON lt.user_id = u.id";

        $params = [];
        if ($status) {
            $sql .= " WHERE t.status = ?";
            $params[] = $status;
        }

        $sql .= " ORDER BY CAST(t.tuinnummer AS UNSIGNED), t.tuinnummer";
        return $db->fetchAll($sql, $params);
    }

    public static function getBeschikbaar(): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT * FROM tuinen WHERE status = 'beschikbaar' ORDER BY CAST(tuinnummer AS UNSIGNED), tuinnummer"
        );
    }

    public static function create(array $data): int
    {
        $db = Database::getInstance();
        return $db->insert('tuinen', $data);
    }

    public static function update(int $id, array $data): bool
    {
        $db = Database::getInstance();
        return $db->update('tuinen', $data, 'id = ?', [$id]);
    }

    public static function delete(int $id): bool
    {
        $db = Database::getInstance();
        return $db->delete('tuinen', 'id = ?', [$id]);
    }

    public static function count(string $status = ''): int
    {
        $db = Database::getInstance();
        if ($status) {
            $row = $db->fetch("SELECT COUNT(*) as c FROM tuinen WHERE status = ?", [$status]);
        } else {
            $row = $db->fetch("SELECT COUNT(*) as c FROM tuinen");
        }
        return (int)$row['c'];
    }
}
