<?php $statusKleuren = ['groen'=>'border-green-500 bg-green-50','oranje'=>'border-orange-500 bg-orange-50','rood'=>'border-red-500 bg-red-50']; ?>

<div class="flex items-center justify-between mb-6">
    <div class="flex items-center space-x-3">
        <a href="<?= url('/admin/inspecties') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Dossier — Tuin <?= e($tuin['tuinnummer']) ?></h1>
            <p class="text-sm text-gray-500"><?= e($tuin['locatie_omschrijving'] ?? '') ?></p>
        </div>
    </div>
    <a href="<?= url('/admin/inspecties/start') ?>" class="px-4 py-2 bg-groen-600 text-white text-sm rounded-lg hover:bg-groen-700">🔍 Nieuwe inspectie</a>
</div>

<!-- Stats -->
<div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
    <div class="bg-white rounded-xl border p-4"><p class="text-2xl font-bold text-gray-700"><?= count($inspecties) ?></p><p class="text-sm text-gray-500">Inspecties</p></div>
    <div class="bg-white rounded-xl border p-4 <?= count($openTickets) > 0 ? 'border-orange-300' : '' ?>"><p class="text-2xl font-bold <?= count($openTickets) > 0 ? 'text-orange-600' : 'text-groen-600' ?>"><?= count($openTickets) ?></p><p class="text-sm text-gray-500">Open tickets</p></div>
    <div class="bg-white rounded-xl border p-4"><p class="text-2xl font-bold text-groen-600"><?= count($afgerondTickets) ?></p><p class="text-sm text-gray-500">Afgerond</p></div>
    <div class="bg-white rounded-xl border p-4"><p class="text-sm font-medium text-gray-700"><?= $huurder ? e($huurder['voornaam'] . ' ' . $huurder['achternaam']) : 'Geen huurder' ?></p><p class="text-sm text-gray-500">Huurder<?= $huurder ? ' sinds ' . date('d-m-Y', strtotime($huurder['start_datum'])) : '' ?></p></div>
</div>

<!-- Open tickets -->
<?php if (!empty($openTickets)): ?>
<div class="bg-white rounded-xl border border-orange-200 mb-6">
    <div class="px-6 py-4 border-b bg-orange-50 rounded-t-xl"><h2 class="font-semibold text-orange-700">⚠️ Openstaande tickets (<?= count($openTickets) ?>)</h2></div>
    <table class="w-full"><thead class="bg-gray-50 border-b"><tr>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Punt</th>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Status</th>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Deadline</th>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Herstel</th>
    </tr></thead><tbody class="divide-y">
        <?php foreach ($openTickets as $t):
            $overdue = $t['status'] !== 'groen' && $t['deadline'] && $t['deadline'] < date('Y-m-d');
        ?>
        <tr class="<?= $overdue ? 'bg-red-50' : '' ?>">
            <td class="px-4 py-2 text-sm font-medium"><?= e($t['titel']) ?></td>
            <td class="px-4 py-2"><?php
                $tkKl = ['groen'=>'bg-green-100 text-green-700','oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700'];
                ?><span class="text-xs px-2 py-1 rounded <?= $tkKl[$t['status']] ?? '' ?>"><?= ucfirst($t['status']) ?></span></td>
            <td class="px-4 py-2 text-sm <?= $overdue ? 'text-red-600 font-bold' : 'text-gray-500' ?>"><?= $t['deadline'] ? date('d-m-Y', strtotime($t['deadline'])) : '—' ?><?= $overdue ? ' ⚠️' : '' ?></td>
            <td class="px-4 py-2 text-sm text-gray-500"><?= $t['laatste_herstel_status'] ? ucfirst($t['laatste_herstel_status']) : '—' ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table>
</div>
<?php endif; ?>

<!-- Inspecties -->
<div class="bg-white rounded-xl border mb-6">
    <div class="px-6 py-4 border-b bg-gray-50 rounded-t-xl"><h2 class="font-semibold text-gray-900">🔍 Inspecties (<?= count($inspecties) ?>)</h2></div>
    <?php if (empty($inspecties)): ?>
    <p class="p-6 text-gray-400 text-sm">Nog geen inspecties uitgevoerd.</p>
    <?php else: ?>
    <table class="w-full"><thead class="bg-gray-50 border-b"><tr>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Datum</th>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Inspecteur</th>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Resultaat</th>
        <th class="px-4 py-2 text-left text-xs font-semibold text-gray-500">Tuinder</th>
        <th class="px-4 py-2 text-right text-xs font-semibold text-gray-500"></th>
    </tr></thead><tbody class="divide-y">
        <?php foreach ($inspecties as $i): ?>
        <tr class="hover:bg-gray-50">
            <td class="px-4 py-2 text-sm"><?= date('d-m-Y H:i', strtotime($i['gestart_op'])) ?></td>
            <td class="px-4 py-2 text-sm"><?= e($i['inspecteur_voornaam'] . ' ' . $i['inspecteur_achternaam']) ?></td>
            <td class="px-4 py-2">
                <?php if ($i['weigert_medewerking']): ?><span class="text-xs text-red-600 font-bold">⛔ Weigering</span>
                <?php elseif ($i['eindstatus']): ?>
                <?php $k = ['groen'=>'bg-green-100 text-green-700','oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700']; ?>
                <span class="text-xs px-2 py-1 rounded <?= $k[$i['eindstatus']] ?? '' ?>"><?= ucfirst($i['eindstatus']) ?></span>
                <?php else: ?><span class="text-xs text-yellow-600">Lopend</span><?php endif; ?>
            </td>
            <td class="px-4 py-2 text-sm"><?= $i['tuinder_aanwezig'] ? '✅' : '❌' ?></td>
            <td class="px-4 py-2 text-right"><a href="<?= url('/admin/inspecties/' . $i['id']) ?>" class="text-sm text-blue-600">Details</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table>
    <?php endif; ?>
</div>

<!-- Afgeronde tickets -->
<?php if (!empty($afgerondTickets)): ?>
<div class="bg-white rounded-xl border">
    <div class="px-6 py-4 border-b bg-gray-50 rounded-t-xl"><h2 class="font-semibold text-gray-900">✅ Afgeronde tickets (<?= count($afgerondTickets) ?>)</h2></div>
    <table class="w-full"><tbody class="divide-y">
        <?php foreach ($afgerondTickets as $t): ?>
        <tr><td class="px-4 py-2 text-sm"><?= e($t['titel']) ?></td><td class="px-4 py-2 text-sm text-gray-400"><?= $t['opgelost_op'] ? date('d-m-Y', strtotime($t['opgelost_op'])) : '' ?></td></tr>
        <?php endforeach; ?>
    </tbody></table>
</div>
<?php endif; ?>
