<div class="flex items-center justify-between mb-6">
    <div class="flex items-center space-x-3">
        <a href="<?= url('/admin/inspecties') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Checklist — Tuin <?= e($inspectie['tuinnummer']) ?></h1>
            <p class="text-sm text-gray-500">Inspectie #<?= $inspectie['id'] ?> · Gestart <?= date('d-m-Y H:i', strtotime($inspectie['gestart_op'])) ?></p>
        </div>
    </div>
</div>

<form method="POST" action="<?= url('/admin/inspecties/' . $inspectie['id'] . '/checklist/save') ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <?php foreach ($grouped as $catId => $cat): ?>
    <div class="bg-white rounded-xl border mb-4">
        <div class="px-6 py-4 border-b bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900"><?= e($cat['naam']) ?></h2>
        </div>
        <div class="divide-y divide-gray-100">
            <?php foreach ($cat['items'] as $item): ?>
            <div class="p-4" id="item-<?= $item['id'] ?>">
                <div class="flex items-start justify-between gap-4">
                    <div class="flex-1">
                        <p class="font-medium text-gray-900 text-sm"><?= e($item['punt_titel']) ?></p>
                        <?php if ($item['punt_omschrijving']): ?>
                        <p class="text-xs text-gray-400 mt-1"><?= e($item['punt_omschrijving']) ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="flex items-center space-x-1 shrink-0">
                        <label class="cursor-pointer">
                            <input type="radio" name="items[<?= $item['id'] ?>][status]" value="ok" <?= $item['status'] === 'ok' ? 'checked' : '' ?> class="hidden peer">
                            <span class="px-3 py-1.5 text-xs rounded-lg border peer-checked:bg-green-500 peer-checked:text-white peer-checked:border-green-500 hover:bg-green-50 transition">✓ OK</span>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="items[<?= $item['id'] ?>][status]" value="niet_ok" <?= $item['status'] === 'niet_ok' ? 'checked' : '' ?> class="hidden peer">
                            <span class="px-3 py-1.5 text-xs rounded-lg border peer-checked:bg-red-500 peer-checked:text-white peer-checked:border-red-500 hover:bg-red-50 transition">✗ Niet OK</span>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="items[<?= $item['id'] ?>][status]" value="nvt" <?= $item['status'] === 'nvt' ? 'checked' : '' ?> class="hidden peer">
                            <span class="px-3 py-1.5 text-xs rounded-lg border peer-checked:bg-gray-500 peer-checked:text-white peer-checked:border-gray-500 hover:bg-gray-50 transition">N.v.t.</span>
                        </label>
                    </div>
                </div>
                <div class="mt-2">
                    <input type="text" name="items[<?= $item['id'] ?>][opmerking]" value="<?= e($item['opmerking'] ?? '') ?>"
                           placeholder="Opmerking (optioneel)" class="w-full px-3 py-1.5 border border-gray-200 rounded-lg text-xs focus:ring-1 focus:ring-groen-500 outline-none">
                </div>
                <!-- Foto upload -->
                <div class="mt-2 flex items-center space-x-2">
                    <button type="button" onclick="uploadPhoto(<?= $item['id'] ?>)" class="text-xs text-blue-600 hover:text-blue-800">📷 Foto toevoegen</button>
                    <div id="photos-<?= $item['id'] ?>" class="flex gap-1"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endforeach; ?>

    <!-- Algemeen rapport -->
    <div class="bg-white rounded-xl border mb-4 p-6">
        <h2 class="font-semibold text-gray-900 mb-3">Algemeen rapport</h2>
        <textarea name="algemeen_rapport" rows="4" class="w-full px-3 py-2 border rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none"
                  placeholder="Eventuele algemene opmerkingen over de inspectie..."><?= e($inspectie['algemeen_rapport'] ?? '') ?></textarea>
    </div>

    <div class="flex items-center justify-between">
        <button type="submit" class="px-6 py-2.5 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700">
            💾 Checklist opslaan
        </button>
        <button type="submit" formaction="<?= url('/admin/inspecties/' . $inspectie['id'] . '/complete') ?>" 
                class="px-6 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700"
                onclick="return confirm('Inspectie afronden? Tickets worden automatisch aangemaakt voor afgekeurde punten.')">
            ✅ Inspectie afronden
        </button>
    </div>
</form>

<!-- Hidden file input for photo uploads -->
<input type="file" id="photoInput" accept="image/*" capture="environment" class="hidden">

<script>
let currentItemId = null;
const photoInput = document.getElementById('photoInput');

function uploadPhoto(itemId) {
    currentItemId = itemId;
    photoInput.click();
}

photoInput.addEventListener('change', async function() {
    if (!this.files[0] || !currentItemId) return;
    
    const formData = new FormData();
    formData.append('photo', this.files[0]);
    formData.append('item_id', currentItemId);
    formData.append('_csrf_token', document.querySelector('input[name="_csrf_token"]').value);
    
    try {
        const res = await fetch('<?= url('/admin/inspecties/' . $inspectie['id'] . '/photo') ?>', {
            method: 'POST',
            body: formData
        });
        const data = await res.json();
        if (data.success) {
            const container = document.getElementById('photos-' + currentItemId);
            const img = document.createElement('img');
            img.src = '<?= url('/storage/uploads/inspecties/') ?>' + data.path;
            img.className = 'w-10 h-10 rounded object-cover border';
            container.appendChild(img);
        } else {
            alert(data.error || 'Upload mislukt');
        }
    } catch(e) {
        alert('Upload mislukt: ' + e.message);
    }
    this.value = '';
});
</script>
