<section class="min-h-[70vh] flex items-center justify-center py-12 px-4">
    <div class="w-full max-w-md">
        <div class="text-center mb-8">
            <div class="w-16 h-16 bg-groen-600 rounded-2xl flex items-center justify-center mx-auto mb-4">
                <svg class="w-10 h-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                          d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/>
                </svg>
            </div>
            <h1 class="text-2xl font-bold text-gray-900">Ledenportaal</h1>
            <p class="text-gray-500 mt-1">Log in om toegang te krijgen tot uw portaal</p>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8">
            <form method="POST" action="<?= url('/login') ?>">
                <?= csrf_field() ?>
                
                <div class="mb-5">
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-1.5">E-mailadres</label>
                    <input type="email" id="email" name="email" value="<?= old('email') ?>" required autofocus
                           class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 focus:border-groen-500 outline-none transition"
                           placeholder="uw@email.nl">
                </div>

                <div class="mb-5">
                    <div class="flex justify-between items-center mb-1.5">
                        <label for="wachtwoord" class="block text-sm font-medium text-gray-700">Wachtwoord</label>
                        <a href="<?= url('/wachtwoord-vergeten') ?>" class="text-xs text-groen-600 hover:text-groen-700">Wachtwoord vergeten?</a>
                    </div>
                    <input type="password" id="wachtwoord" name="wachtwoord" required
                           class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 focus:border-groen-500 outline-none transition"
                           placeholder="••••••••">
                </div>

                <button type="submit" 
                        class="w-full py-2.5 px-4 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700 focus:ring-2 focus:ring-offset-2 focus:ring-groen-500 transition">
                    Inloggen
                </button>
            </form>
        </div>

        <p class="text-center text-sm text-gray-500 mt-6">
            Nog geen lid? <a href="<?= url('/ik-wil-een-tuin') ?>" class="text-groen-600 hover:text-groen-700 font-medium">Word aspirant-lid</a>
        </p>
    </div>
</section>
