<?php
/**
 * Application Configuration
 * VTV De Beukhoeve
 */

return [
    'name' => 'VTV De Beukhoeve',
    'url' => getenv('APP_URL') ?: 'http://localhost',
    'debug' => getenv('APP_DEBUG') ?: false,
    'timezone' => 'Europe/Amsterdam',
    'locale' => 'nl_NL',
    
    // Session
    'session' => [
        'lifetime' => 120, // minutes
        'secure' => true,
        'httponly' => true,
        'samesite' => 'Lax',
    ],
    
    // Upload limits
    'uploads' => [
        'max_size' => 5 * 1024 * 1024, // 5MB
        'allowed_types' => ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx'],
        'path' => __DIR__ . '/../storage/uploads',
    ],
    
    // Rate limiting
    'rate_limit' => [
        'login_attempts' => 5,
        'login_window' => 900, // 15 minutes
    ],
    
    // Pagination
    'per_page' => 20,
];
