<?php
$dbContent = $content['body']['inhoud'] ?? '';
if ($dbContent): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="prose prose-lg max-w-none bg-white rounded-xl shadow-sm border border-gray-100 p-8">
        <?= $dbContent ?>
    </div>
</section>
<?php else: ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h1 class="text-3xl font-bold text-gray-900 mb-2">Contact</h1>
    <p class="text-gray-500 mb-10">Neem gerust contact met ons op via onderstaande gegevens.</p>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        <!-- Contact Info -->
        <div class="space-y-6">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="font-semibold text-gray-900 mb-4">Adres</h2>
                <div class="text-gray-600 space-y-2">
                    <p>📍 Beukhoevelaan 1</p>
                    <p>1234 AB Amsterdam</p>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="font-semibold text-gray-900 mb-4">E-mail</h2>
                <div class="text-gray-600 space-y-2">
                    <p>📧 Algemeen: <a href="mailto:info@beukhoeve.nl" class="text-groen-600 hover:underline">info@beukhoeve.nl</a></p>
                    <p>📧 Bestuur: <a href="mailto:bestuur@beukhoeve.nl" class="text-groen-600 hover:underline">bestuur@beukhoeve.nl</a></p>
                    <p>📧 Ledenadministratie: <a href="mailto:leden@beukhoeve.nl" class="text-groen-600 hover:underline">leden@beukhoeve.nl</a></p>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="font-semibold text-gray-900 mb-4">Telefoon</h2>
                <div class="text-gray-600 space-y-2">
                    <p>📞 020-1234567 <span class="text-gray-400 text-sm">(ma-vr 9:00-17:00)</span></p>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="font-semibold text-gray-900 mb-4">Commissies</h2>
                <p class="text-gray-600 text-sm mb-3">Heeft u een specifieke vraag voor een commissie?</p>
                <a href="<?= url('/commissies') ?>" class="text-groen-600 hover:text-groen-700 font-medium text-sm">Bekijk commissies en contactgegevens →</a>
            </div>
        </div>

        <!-- Map / Aspirant -->
        <div class="space-y-6">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="font-semibold text-gray-900 mb-4">Locatie</h2>
                <div class="bg-gray-200 rounded-lg h-64 flex items-center justify-center text-gray-400">
                    <!-- Hier kan later een Google Maps embed komen -->
                    <p>Kaart placeholder</p>
                </div>
            </div>

            <div class="bg-groen-50 rounded-xl border border-groen-200 p-6">
                <h2 class="font-semibold text-groen-800 mb-2">🌱 Interesse in een tuin?</h2>
                <p class="text-groen-700 text-sm mb-4">
                    Wilt u lid worden van VTV De Beukhoeve? Bekijk onze aspirant-procedure.
                </p>
                <a href="<?= url('/ik-wil-een-tuin') ?>" class="inline-flex items-center px-4 py-2 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition">
                    Meer informatie →
                </a>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
