<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($title ?? 'VTV De Beukhoeve') ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Display:ital@0;1&family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'groen': {
                            50: '#f0fdf4', 100: '#dcfce7', 200: '#bbf7d0', 300: '#86efac',
                            400: '#4ade80', 500: '#22c55e', 600: '#16a34a', 700: '#15803d',
                            800: '#166534', 900: '#14532d', 950: '#0a2618',
                        },
                        'aarde': {
                            50: '#faf6f1', 100: '#f0e6d3', 200: '#e0cda7', 300: '#c9a96e',
                            400: '#b8904a', 500: '#a07735', 600: '#8a6230', 700: '#6f4e2a',
                            800: '#5c4127', 900: '#4d3623',
                        },
                        'creme': '#f7f3ed',
                        'donker': '#0f1f15',
                    },
                    fontFamily: {
                        'display': ['"DM Serif Display"', 'Georgia', 'serif'],
                        'body': ['"Plus Jakarta Sans"', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <style>
        [x-cloak] { display: none !important; }
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        .font-display { font-family: 'DM Serif Display', Georgia, serif; }
        @keyframes fadeUp { from { opacity: 0; transform: translateY(30px); } to { opacity: 1; transform: translateY(0); } }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        .animate-fade-up { animation: fadeUp 0.8s ease-out both; }
        .animate-fade-in { animation: fadeIn 1s ease-out both; }
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        .delay-400 { animation-delay: 0.4s; }
        .delay-500 { animation-delay: 0.5s; }
        .grain { position: relative; }
        .grain::after {
            content: ''; position: absolute; inset: 0; opacity: 0.03;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 256 256' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noise'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.9' numOctaves='4' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noise)'/%3E%3C/svg%3E");
            pointer-events: none;
        }
    </style>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="min-h-screen flex flex-col bg-creme text-gray-800">
    
    <?php if (!empty($calamiteit)): ?>
    <div class="bg-red-600 text-white px-4 py-3 text-center font-semibold text-sm">
        ⚠️ <?= e($calamiteit['titel']) ?>: <?= e($calamiteit['inhoud']) ?>
    </div>
    <?php endif; ?>

    <?php $isHome = ($_SERVER['REQUEST_URI'] === \App\Core\View::basePath() . '/' || $_SERVER['REQUEST_URI'] === \App\Core\View::basePath()); ?>

    <!-- Header -->
    <header class="<?= $isHome ? 'absolute top-0 left-0 right-0 z-50' : 'bg-donker' ?> transition-all" x-data="{ mobileOpen: false, scrolled: false }" 
            @scroll.window="scrolled = window.scrollY > 50"
            :class="scrolled && <?= $isHome ? 'true' : 'false' ?> ? 'bg-donker/95 backdrop-blur-md' : ''">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                <a href="<?= url('/') ?>" class="flex items-center space-x-3 group">
                    <div class="w-10 h-10 bg-groen-500 rounded-xl flex items-center justify-center group-hover:bg-groen-400 transition-colors">
                        <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/>
                        </svg>
                    </div>
                    <div>
                        <span class="text-lg font-bold text-white">De Beukhoeve</span>
                        <span class="hidden sm:block text-xs text-groen-300 -mt-0.5">Volkstuinvereniging</span>
                    </div>
                </a>

                <nav class="hidden lg:flex items-center space-x-1">
                    <a href="<?= url('/') ?>" class="px-4 py-2 rounded-lg text-sm font-medium text-white/80 hover:text-white hover:bg-white/10 transition">Home</a>
                    <div class="relative" x-data="{ open: false }" @mouseenter="open = true" @mouseleave="open = false">
                        <button class="px-4 py-2 rounded-lg text-sm font-medium text-white/80 hover:text-white hover:bg-white/10 transition flex items-center">
                            Over ons
                            <svg class="ml-1 w-3.5 h-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                        </button>
                        <div x-show="open" x-cloak x-transition class="absolute left-0 mt-1 w-52 bg-donker/95 backdrop-blur-md rounded-xl border border-white/10 py-2 z-50 shadow-2xl">
                            <a href="<?= url('/over-ons') ?>" class="block px-4 py-2.5 text-sm text-white/70 hover:text-white hover:bg-white/10">Wie zijn wij</a>
                            <a href="<?= url('/bestuur') ?>" class="block px-4 py-2.5 text-sm text-white/70 hover:text-white hover:bg-white/10">Bestuur</a>
                            <a href="<?= url('/commissies') ?>" class="block px-4 py-2.5 text-sm text-white/70 hover:text-white hover:bg-white/10">Commissies</a>
                            <a href="<?= url('/faciliteiten') ?>" class="block px-4 py-2.5 text-sm text-white/70 hover:text-white hover:bg-white/10">Faciliteiten</a>
                        </div>
                    </div>
                    <a href="<?= url('/plattegrond') ?>" class="px-4 py-2 rounded-lg text-sm font-medium text-white/80 hover:text-white hover:bg-white/10 transition">Plattegrond</a>
                    <a href="<?= url('/beschikbare-tuinen') ?>" class="px-4 py-2 rounded-lg text-sm font-medium text-white/80 hover:text-white hover:bg-white/10 transition">Tuinen</a>
                    <a href="<?= url('/contact') ?>" class="px-4 py-2 rounded-lg text-sm font-medium text-white/80 hover:text-white hover:bg-white/10 transition">Contact</a>
                </nav>

                <div class="flex items-center space-x-3">
                    <?php if ($auth['check']): ?>
                    <a href="<?= url('/portaal') ?>" class="hidden sm:inline-flex items-center px-5 py-2.5 text-sm font-semibold text-donker bg-groen-400 rounded-xl hover:bg-groen-300 transition-colors">
                        Mijn Portaal
                    </a>
                    <?php else: ?>
                    <a href="<?= url('/login') ?>" class="hidden sm:inline-flex items-center px-5 py-2.5 text-sm font-semibold text-donker bg-groen-400 rounded-xl hover:bg-groen-300 transition-colors">
                        Inloggen
                    </a>
                    <?php endif; ?>
                    <button @click="mobileOpen = !mobileOpen" class="lg:hidden p-2 rounded-lg text-white/80 hover:text-white hover:bg-white/10">
                        <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path x-show="!mobileOpen" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                            <path x-show="mobileOpen" x-cloak stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        <div x-show="mobileOpen" x-cloak x-transition class="lg:hidden bg-donker/95 backdrop-blur-md border-t border-white/10">
            <div class="px-4 py-4 space-y-1">
                <a href="<?= url('/') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Home</a>
                <a href="<?= url('/over-ons') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Over ons</a>
                <a href="<?= url('/bestuur') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Bestuur</a>
                <a href="<?= url('/commissies') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Commissies</a>
                <a href="<?= url('/faciliteiten') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Faciliteiten</a>
                <a href="<?= url('/plattegrond') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Plattegrond</a>
                <a href="<?= url('/beschikbare-tuinen') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Beschikbare tuinen</a>
                <a href="<?= url('/contact') ?>" class="block px-4 py-2.5 rounded-lg text-white/80 hover:text-white hover:bg-white/10">Contact</a>
                <a href="<?= url('/ik-wil-een-tuin') ?>" class="block px-4 py-2.5 rounded-lg font-semibold text-groen-400 hover:bg-white/10">🌱 Ik wil een tuin</a>
                <?php if ($auth['check']): ?>
                <a href="<?= url('/portaal') ?>" class="block px-4 py-2.5 rounded-lg bg-groen-500 text-white font-semibold text-center mt-2">Mijn Portaal</a>
                <?php else: ?>
                <a href="<?= url('/login') ?>" class="block px-4 py-2.5 rounded-lg bg-groen-500 text-white font-semibold text-center mt-2">Inloggen</a>
                <?php endif; ?>
            </div>
        </div>
    </header>

    <?php foreach (['success' => 'green', 'error' => 'red', 'warning' => 'yellow', 'info' => 'blue'] as $type => $color): ?>
        <?php if (!empty($flash[$type])): ?>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-4" x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 5000)">
            <div class="rounded-xl bg-<?= $color ?>-50 border border-<?= $color ?>-200 p-4 flex justify-between items-center">
                <p class="text-sm text-<?= $color ?>-800"><?= e($flash[$type]) ?></p>
                <button @click="show = false" class="text-<?= $color ?>-500"><svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg></button>
            </div>
        </div>
        <?php endif; ?>
    <?php endforeach; ?>

    <?php if (!$isHome): ?>
    <div class="h-20"></div>
    <?php endif; ?>

    <main class="flex-1"><?= $content ?></main>

    <!-- Floating scroll button -->
    <div x-data="{ atTop: true }" @scroll.window="atTop = window.scrollY < 300" class="fixed bottom-6 right-6 z-50">
        <button x-show="!atTop" x-transition @click="window.scrollTo({top: 0, behavior: 'smooth'})"
                class="w-12 h-12 bg-groen-600 hover:bg-groen-500 text-white rounded-full shadow-lg shadow-groen-600/30 flex items-center justify-center transition-all hover:scale-110">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 15l7-7 7 7"/></svg>
        </button>
    </div>

    <!-- Footer -->
    <footer class="bg-donker text-white grain">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-10">
                <div class="md:col-span-1">
                    <div class="flex items-center space-x-3 mb-5">
                        <div class="w-10 h-10 bg-groen-500 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/></svg>
                        </div>
                        <span class="text-lg font-bold">De Beukhoeve</span>
                    </div>
                    <p class="text-white/50 text-sm leading-relaxed">Een bruisende volkstuinvereniging waar natuur en gemeenschap samenkomen.</p>
                </div>
                <div>
                    <h4 class="text-xs font-semibold uppercase tracking-widest text-groen-400 mb-5">Vereniging</h4>
                    <ul class="space-y-3 text-sm">
                        <li><a href="<?= url('/over-ons') ?>" class="text-white/50 hover:text-white transition">Over ons</a></li>
                        <li><a href="<?= url('/bestuur') ?>" class="text-white/50 hover:text-white transition">Bestuur</a></li>
                        <li><a href="<?= url('/commissies') ?>" class="text-white/50 hover:text-white transition">Commissies</a></li>
                        <li><a href="<?= url('/faciliteiten') ?>" class="text-white/50 hover:text-white transition">Faciliteiten</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-xs font-semibold uppercase tracking-widest text-groen-400 mb-5">Tuinen</h4>
                    <ul class="space-y-3 text-sm">
                        <li><a href="<?= url('/beschikbare-tuinen') ?>" class="text-white/50 hover:text-white transition">Beschikbare tuinen</a></li>
                        <li><a href="<?= url('/plattegrond') ?>" class="text-white/50 hover:text-white transition">Plattegrond</a></li>
                        <li><a href="<?= url('/ik-wil-een-tuin') ?>" class="text-white/50 hover:text-white transition">Aspirant worden</a></li>
                        <li><a href="<?= url('/contact') ?>" class="text-white/50 hover:text-white transition">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-xs font-semibold uppercase tracking-widest text-groen-400 mb-5">Contact</h4>
                    <div class="text-sm text-white/50 space-y-3">
                        <p>📍 Beukhoevelaan 1, Amsterdam</p>
                        <p>📧 info@beukhoeve.nl</p>
                        <p>📞 020-1234567</p>
                    </div>
                </div>
            </div>
            <div class="mt-12 pt-8 border-t border-white/10 flex flex-col sm:flex-row justify-between items-center gap-4">
                <p class="text-sm text-white/30">&copy; <?= date('Y') ?> VTV De Beukhoeve. Alle rechten voorbehouden.</p>
                <a href="<?= url('/privacy') ?>" class="text-sm text-white/30 hover:text-white/60 transition">Privacybeleid</a>
            </div>
        </div>
    </footer>
</body>
</html>
