<?php

namespace App\Helpers;

class Env
{
    /**
     * Load .env file into environment variables
     */
    public static function load(string $path): void
    {
        $file = $path . '/.env';
        
        if (!file_exists($file)) {
            return;
        }

        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            // Skip comments
            if (str_starts_with(trim($line), '#')) {
                continue;
            }

            // Parse KEY=VALUE
            if (str_contains($line, '=')) {
                [$key, $value] = explode('=', $line, 2);
                $key = trim($key);
                $value = trim($value);

                // Remove surrounding quotes
                if (preg_match('/^(["\'])(.*)\\1$/', $value, $matches)) {
                    $value = $matches[2];
                }

                // Convert string booleans
                if (strtolower($value) === 'true') $value = 'true';
                if (strtolower($value) === 'false') $value = 'false';

                putenv("{$key}={$value}");
                $_ENV[$key] = $value;
            }
        }
    }
}
