<?php
$dbContent = $content['body']['inhoud'] ?? '';
if ($dbContent): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="prose prose-lg max-w-none bg-white rounded-xl shadow-sm border border-gray-100 p-8">
        <?= $dbContent ?>
    </div>
</section>
<?php else: ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h1 class="text-3xl font-bold text-gray-900 mb-2">Beschikbare Tuinen</h1>
    <p class="text-gray-500 mb-10">Bekijk welke tuinen momenteel beschikbaar zijn.</p>

    <?php if (!empty($tuinen)): ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php foreach ($tuinen as $tuin): ?>
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 hover:shadow-md transition">
            <div class="flex items-center justify-between mb-4">
                <span class="text-lg font-bold text-groen-700">Tuin <?= e($tuin['tuinnummer']) ?></span>
                <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium bg-groen-100 text-groen-700">Beschikbaar</span>
            </div>
            <div class="space-y-2 text-sm text-gray-600">
                <?php if ($tuin['oppervlakte']): ?>
                <p>📐 <?= number_format($tuin['oppervlakte'], 0, ',', '.') ?> m²</p>
                <?php endif; ?>
                <p>🏷️ Type: <?= e(ucfirst($tuin['type'])) ?></p>
                <p>🚰 Water: <?= $tuin['heeft_water'] ? 'Ja' : 'Nee' ?></p>
                <p>⚡ Elektra: <?= $tuin['heeft_elektra'] ? 'Ja' : 'Nee' ?></p>
                <?php if ($tuin['locatie_omschrijving']): ?>
                <p>📍 <?= e($tuin['locatie_omschrijving']) ?></p>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <div class="mt-8 text-center">
        <a href="<?= url('/ik-wil-een-tuin') ?>" class="inline-flex items-center px-6 py-3 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700 transition">
            🌱 Interesse? Word aspirant-lid
        </a>
    </div>
    <?php else: ?>
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-12 text-center">
        <span class="text-5xl block mb-4">🌻</span>
        <h2 class="text-xl font-semibold text-gray-900 mb-2">Momenteel geen tuinen beschikbaar</h2>
        <p class="text-gray-500 mb-6">Alle tuinen zijn op dit moment bezet. U kunt zich aanmelden als aspirant-lid om op de wachtlijst te komen.</p>
        <a href="<?= url('/ik-wil-een-tuin') ?>" class="inline-flex items-center px-6 py-3 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700 transition">
            Aanmelden als aspirant →
        </a>
    </div>
    <?php endif; ?>
</section>
<?php endif; ?>
