<?php

namespace App\Models;

use App\Core\Database;

class Setting
{
    private static array $cache = [];

    /**
     * Haal een instelling op
     */
    public static function get(string $sleutel, string $default = ''): string
    {
        if (isset(self::$cache[$sleutel])) {
            return self::$cache[$sleutel];
        }

        $db = Database::getInstance();
        $row = $db->fetch("SELECT waarde FROM site_instellingen WHERE sleutel = ?", [$sleutel]);
        
        $value = $row['waarde'] ?? $default;
        self::$cache[$sleutel] = $value;
        return $value;
    }

    /**
     * Sla een instelling op
     */
    public static function set(string $sleutel, ?string $waarde): bool
    {
        $db = Database::getInstance();
        self::$cache[$sleutel] = $waarde ?? '';
        
        $existing = $db->fetch("SELECT id FROM site_instellingen WHERE sleutel = ?", [$sleutel]);
        if ($existing) {
            return $db->update('site_instellingen', ['waarde' => $waarde], 'id = ?', [$existing['id']]);
        }
        return false;
    }

    /**
     * Haal alle instellingen van een groep op
     */
    public static function getGroup(string $groep): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT * FROM site_instellingen WHERE groep = ? ORDER BY id", 
            [$groep]
        );
    }

    /**
     * Haal alle instellingen op (gegroepeerd)
     */
    public static function getAll(): array
    {
        $db = Database::getInstance();
        $rows = $db->fetchAll("SELECT * FROM site_instellingen ORDER BY groep, id");
        
        $grouped = [];
        foreach ($rows as $row) {
            $grouped[$row['groep']][] = $row;
        }
        return $grouped;
    }
}
