<?php

namespace App\Controllers;

use App\Core\Auth;

class PortalController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
        $this->requireAuth();
    }

    /**
     * Member dashboard
     */
    public function dashboard(): void
    {
        $userId = Auth::id();

        // Open meldingen
        $meldingen = $this->db->fetchAll(
            "SELECT * FROM meldingen WHERE user_id = ? AND status NOT IN ('afgerond', 'afgewezen') 
             ORDER BY created_at DESC LIMIT 5",
            [$userId]
        );

        // Open aanvragen
        $aanvragen = $this->db->fetchAll(
            "SELECT * FROM vergunningen WHERE user_id = ? AND status NOT IN ('goedgekeurd', 'afgewezen') 
             ORDER BY created_at DESC LIMIT 5",
            [$userId]
        );

        // Betalingsstatus
        $openstaand = $this->db->fetch(
            "SELECT COALESCE(SUM(bedrag), 0) as totaal FROM betalingen 
             WHERE user_id = ? AND status = 'openstaand'",
            [$userId]
        );

        // Ongelezen berichten
        $berichten = $this->db->fetch(
            "SELECT COUNT(*) as count FROM notificaties 
             WHERE user_id = ? AND gelezen = 0",
            [$userId]
        );

        // Werkbeurten saldo
        $werkbeurten = $this->db->fetch(
            "SELECT COALESCE(SUM(CASE WHEN type = 'credit' THEN uren ELSE -uren END), 0) as saldo
             FROM werkbeurten WHERE user_id = ?",
            [$userId]
        );

        $this->render('portal/dashboard', [
            'title' => 'Mijn Portaal - VTV De Beukhoeve',
            'meldingen' => $meldingen,
            'aanvragen' => $aanvragen,
            'openstaand_bedrag' => $openstaand['totaal'] ?? 0,
            'ongelezen_berichten' => $berichten['count'] ?? 0,
            'werkbeurten_saldo' => $werkbeurten['saldo'] ?? 0,
        ], 'portal');
    }
}
