<h1 class="text-2xl font-bold text-gray-900 mb-6">Instellingen</h1>

<form method="POST" action="<?= url('/admin/instellingen') ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <?php
    $groepLabels = [
        'algemeen' => 'Algemeen',
        'contact' => 'Contactgegevens',
        'social' => 'Social media',
        'uiterlijk' => 'Uiterlijk',
    ];
    
    foreach ($settings as $groep => $items): ?>
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900"><?= e($groepLabels[$groep] ?? ucfirst($groep)) ?></h2>
        </div>
        <div class="p-6 space-y-5">
            <?php foreach ($items as $item): ?>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1"><?= e($item['label'] ?? $item['sleutel']) ?></label>
                
                <?php if ($item['type'] === 'textarea'): ?>
                <textarea name="instelling[<?= e($item['sleutel']) ?>]" rows="3"
                          class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none"><?= e($item['waarde'] ?? '') ?></textarea>
                
                <?php elseif ($item['type'] === 'boolean'): ?>
                <label class="flex items-center space-x-2 cursor-pointer">
                    <input type="hidden" name="instelling[<?= e($item['sleutel']) ?>]" value="0">
                    <input type="checkbox" name="instelling[<?= e($item['sleutel']) ?>]" value="1" 
                           <?= ($item['waarde'] ?? '0') === '1' ? 'checked' : '' ?>
                           class="w-4 h-4 text-groen-600 rounded">
                    <span class="text-sm text-gray-600">Ingeschakeld</span>
                </label>
                
                <?php elseif ($item['type'] === 'color'): ?>
                <div class="flex items-center space-x-3">
                    <input type="color" name="instelling[<?= e($item['sleutel']) ?>]" 
                           value="<?= e($item['waarde'] ?? '#16a34a') ?>"
                           class="h-10 w-16 rounded border border-gray-300 cursor-pointer">
                    <input type="text" value="<?= e($item['waarde'] ?? '#16a34a') ?>" 
                           class="px-4 py-2.5 border border-gray-300 rounded-lg text-sm w-32" readonly>
                </div>
                
                <?php elseif ($item['type'] === 'image'): ?>
                <?php if (!empty($item['waarde'])): ?>
                <div class="mb-2">
                    <img src="<?= url('/storage/uploads/media/' . $item['waarde']) ?>" alt="" class="h-16 rounded">
                </div>
                <?php endif; ?>
                <input type="file" name="instelling_file[<?= e($item['sleutel']) ?>]" accept="image/*"
                       class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-groen-50 file:text-groen-700 hover:file:bg-groen-100">
                
                <?php elseif ($item['type'] === 'number'): ?>
                <input type="number" name="instelling[<?= e($item['sleutel']) ?>]" 
                       value="<?= e($item['waarde'] ?? '') ?>"
                       class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                
                <?php else: ?>
                <input type="text" name="instelling[<?= e($item['sleutel']) ?>]" 
                       value="<?= e($item['waarde'] ?? '') ?>"
                       class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endforeach; ?>

    <div class="flex justify-end">
        <button type="submit" class="px-6 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition">
            Instellingen opslaan
        </button>
    </div>
</form>
