<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Pagina's</h1>
</div>

<div class="bg-white rounded-xl border border-gray-200">
    <div class="divide-y divide-gray-100">
        <?php foreach ($pageLabels as $slug => $label): 
            $page = null;
            foreach ($pages as $p) {
                if ($p['pagina_slug'] === $slug) { $page = $p; break; }
            }
        ?>
        <a href="<?= url('/admin/paginas/' . $slug) ?>" class="flex items-center justify-between px-6 py-4 hover:bg-gray-50 transition">
            <div class="flex items-center space-x-4">
                <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                </div>
                <div>
                    <p class="font-medium text-gray-900"><?= e($label) ?></p>
                    <p class="text-sm text-gray-500">/<?= e($slug === 'home' ? '' : $slug) ?></p>
                </div>
            </div>
            <div class="flex items-center space-x-4">
                <?php if ($page): ?>
                <span class="text-xs text-gray-400"><?= date('d-m-Y H:i', strtotime($page['laatst_bijgewerkt'])) ?></span>
                <?php endif; ?>
                <svg class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
</div>
