<?php $naam = e($lid['voornaam'] . ' ' . ($lid['tussenvoegsel'] ? $lid['tussenvoegsel'] . ' ' : '') . $lid['achternaam']); ?>

<div class="flex items-center justify-between mb-6">
    <div class="flex items-center space-x-3">
        <a href="<?= url('/admin/leden') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900"><?= $naam ?></h1>
            <p class="text-sm text-gray-500"><?= e($lid['lidnummer'] ?? 'Geen lidnummer') ?> · <?= e($lid['role_naam'] ?? 'Lid') ?></p>
        </div>
    </div>
    <div class="flex items-center space-x-2">
        <a href="<?= url('/admin/leden/' . $lid['id'] . '/bewerk') ?>" class="px-4 py-2 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700">Bewerken</a>
        <?php if ($lid['actief']): ?>
        <form method="POST" action="<?= url('/admin/leden/' . $lid['id'] . '/deactiveer') ?>" onsubmit="return confirm('Dit lid deactiveren?')">
            <?= csrf_field() ?>
            <button class="px-4 py-2 bg-red-50 text-red-600 text-sm font-medium rounded-lg hover:bg-red-100">Deactiveren</button>
        </form>
        <?php else: ?>
        <form method="POST" action="<?= url('/admin/leden/' . $lid['id'] . '/activeer') ?>">
            <?= csrf_field() ?>
            <button class="px-4 py-2 bg-groen-50 text-groen-600 text-sm font-medium rounded-lg hover:bg-groen-100">Activeren</button>
        </form>
        <?php endif; ?>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Hoofdinfo -->
    <div class="lg:col-span-2 space-y-6">
        <!-- Persoonsgegevens -->
        <div class="bg-white rounded-xl border border-gray-200">
            <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                <h2 class="font-semibold text-gray-900">Persoonsgegevens</h2>
            </div>
            <div class="p-6 grid grid-cols-2 gap-4 text-sm">
                <div><span class="text-gray-500">E-mail:</span><br><a href="mailto:<?= e($lid['email']) ?>" class="text-groen-600"><?= e($lid['email']) ?></a></div>
                <div><span class="text-gray-500">Telefoon:</span><br><?= e($lid['telefoon'] ?? '—') ?></div>
                <div><span class="text-gray-500">Mobiel:</span><br><?= e($lid['mobiel'] ?? '—') ?></div>
                <div><span class="text-gray-500">Geboortedatum:</span><br><?= $lid['geboortedatum'] ? date('d-m-Y', strtotime($lid['geboortedatum'])) : '—' ?></div>
                <div class="col-span-2"><span class="text-gray-500">Adres:</span><br>
                    <?php if ($lid['straat']): ?>
                    <?= e($lid['straat']) ?> <?= e($lid['huisnummer'] ?? '') ?><br>
                    <?= e($lid['postcode'] ?? '') ?> <?= e($lid['woonplaats'] ?? '') ?>
                    <?php else: ?>—<?php endif; ?>
                </div>
                <div><span class="text-gray-500">Kenteken:</span><br><?= e($lid['kenteken'] ?? '—') ?></div>
                <div><span class="text-gray-500">Lid sinds:</span><br><?= date('d-m-Y', strtotime($lid['created_at'])) ?></div>
            </div>
        </div>

        <!-- Partner -->
        <?php if ($lid['partner_voornaam']): ?>
        <div class="bg-white rounded-xl border border-gray-200">
            <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                <h2 class="font-semibold text-gray-900">Partner</h2>
            </div>
            <div class="p-6 grid grid-cols-2 gap-4 text-sm">
                <div><span class="text-gray-500">Naam:</span><br><?= e($lid['partner_voornaam']) ?> <?= e($lid['partner_achternaam'] ?? '') ?></div>
                <div><span class="text-gray-500">Telefoon:</span><br><?= e($lid['partner_telefoon'] ?? '—') ?></div>
                <div><span class="text-gray-500">E-mail:</span><br><?= e($lid['partner_email'] ?? '—') ?></div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Noodcontact -->
        <?php if ($lid['noodcontact_naam']): ?>
        <div class="bg-white rounded-xl border border-gray-200">
            <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
                <h2 class="font-semibold text-gray-900">Noodcontact</h2>
            </div>
            <div class="p-6 grid grid-cols-3 gap-4 text-sm">
                <div><span class="text-gray-500">Naam:</span><br><?= e($lid['noodcontact_naam']) ?></div>
                <div><span class="text-gray-500">Telefoon:</span><br><?= e($lid['noodcontact_telefoon'] ?? '—') ?></div>
                <div><span class="text-gray-500">Relatie:</span><br><?= e($lid['noodcontact_relatie'] ?? '—') ?></div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Status -->
        <div class="bg-white rounded-xl border border-gray-200 p-6">
            <h3 class="font-semibold text-gray-900 mb-4">Status</h3>
            <div class="space-y-3 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">Account</span>
                    <?php if ($lid['actief']): ?>
                    <span class="text-groen-600 font-medium">Actief</span>
                    <?php else: ?>
                    <span class="text-red-600 font-medium">Inactief</span>
                    <?php endif; ?>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Rol</span>
                    <span class="font-medium"><?= e($lid['role_naam'] ?? 'Lid') ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Laatste login</span>
                    <span><?= $lid['laatste_login'] ? date('d-m-Y H:i', strtotime($lid['laatste_login'])) : 'Nooit' ?></span>
                </div>
            </div>
        </div>

        <!-- Tuin -->
        <div class="bg-white rounded-xl border border-gray-200 p-6">
            <h3 class="font-semibold text-gray-900 mb-4">Tuin</h3>
            <?php if ($tuin): ?>
            <div class="space-y-3 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">Nummer</span>
                    <span class="font-bold text-groen-700 text-lg"><?= e($tuin['tuinnummer']) ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Oppervlakte</span>
                    <span><?= $tuin['oppervlakte'] ? $tuin['oppervlakte'] . ' m²' : '—' ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Sinds</span>
                    <span><?= date('d-m-Y', strtotime($tuin['start_datum'])) ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Water</span>
                    <span><?= $tuin['heeft_water'] ? '✓' : '✗' ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Elektra</span>
                    <span><?= $tuin['heeft_elektra'] ? '✓' : '✗' ?></span>
                </div>
            </div>
            <?php else: ?>
            <p class="text-sm text-gray-400 italic">Geen tuin toegewezen</p>
            <?php endif; ?>
        </div>
    </div>
</div>
