<?php

namespace App\Models;

use App\Core\Database;

class Ticket
{
    public static function find(int $id): ?array
    {
        $db = Database::getInstance();
        return $db->fetch(
            "SELECT t.*, tu.tuinnummer, cp.titel as punt_titel
             FROM inspectie_tickets t
             JOIN tuinen tu ON tu.id = t.tuin_id
             LEFT JOIN controle_punten cp ON cp.id = t.controle_punt_id
             WHERE t.id = ?", [$id]
        );
    }

    public static function getForTuin(int $tuinId): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT t.*, tu.tuinnummer,
                    (SELECT hm.status FROM herstel_meldingen hm WHERE hm.ticket_id = t.id ORDER BY hm.created_at DESC LIMIT 1) as laatste_herstel_status,
                    (SELECT hm.created_at FROM herstel_meldingen hm WHERE hm.ticket_id = t.id ORDER BY hm.created_at DESC LIMIT 1) as laatste_herstel_datum
             FROM inspectie_tickets t
             JOIN tuinen tu ON tu.id = t.tuin_id
             WHERE t.tuin_id = ?
             ORDER BY t.created_at DESC", [$tuinId]
        );
    }

    public static function getForInspectie(int $inspectieId): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT t.* FROM inspectie_tickets t WHERE t.inspectie_id = ? ORDER BY t.created_at DESC", [$inspectieId]
        );
    }

    public static function getAll(string $status = ''): array
    {
        $db = Database::getInstance();
        $where = '1=1';
        $params = [];
        if ($status) {
            $where = "t.status = ?";
            $params[] = $status;
        }
        return $db->fetchAll(
            "SELECT t.*, tu.tuinnummer
             FROM inspectie_tickets t
             JOIN tuinen tu ON tu.id = t.tuin_id
             WHERE {$where}
             ORDER BY t.created_at DESC", $params
        );
    }

    public static function create(array $data): int
    {
        $db = Database::getInstance();
        return $db->insert('inspectie_tickets', $data);
    }

    public static function update(int $id, array $data): bool
    {
        $db = Database::getInstance();
        return $db->update('inspectie_tickets', $data, 'id = ?', [$id]);
    }

    public static function countOpen(): int
    {
        $db = Database::getInstance();
        $row = $db->fetch("SELECT COUNT(*) as c FROM inspectie_tickets WHERE status != 'groen'");
        return (int)$row['c'];
    }
}
