<h1 class="text-2xl font-bold text-gray-900 mb-6">Mijn tuindossier</h1>

<!-- Mijn tuinen -->
<div class="bg-white rounded-xl border p-6 mb-6">
    <h2 class="font-semibold text-gray-900 mb-3">Mijn tuin(en)</h2>
    <?php foreach ($tuinen as $t): ?>
    <div class="flex items-center space-x-3">
        <span class="text-lg font-bold text-groen-700">🌱 Tuin <?= e($t['tuinnummer']) ?></span>
        <span class="text-sm text-gray-500">Sinds <?= date('d-m-Y', strtotime($t['start_datum'])) ?></span>
    </div>
    <?php endforeach; ?>
</div>

<!-- Statistieken -->
<div class="grid grid-cols-2 sm:grid-cols-4 gap-4 mb-6">
    <div class="bg-white rounded-xl border p-4 <?= count($needsAction) > 0 ? 'border-orange-300' : '' ?>">
        <p class="text-2xl font-bold <?= count($needsAction) > 0 ? 'text-orange-600' : 'text-groen-600' ?>"><?= count($needsAction) ?></p>
        <p class="text-sm text-gray-500">Actie vereist</p>
    </div>
    <div class="bg-white rounded-xl border p-4">
        <p class="text-2xl font-bold text-blue-600"><?= count($pendingReview) ?></p>
        <p class="text-sm text-gray-500">Wacht op beoordeling</p>
    </div>
    <?php if (count($rejected) > 0): ?>
    <div class="bg-white rounded-xl border p-4 border-red-300">
        <p class="text-2xl font-bold text-red-600"><?= count($rejected) ?></p>
        <p class="text-sm text-gray-500">Afgekeurd</p>
    </div>
    <?php endif; ?>
    <div class="bg-white rounded-xl border p-4">
        <p class="text-2xl font-bold text-groen-600"><?= count($resolvedTickets) ?></p>
        <p class="text-sm text-gray-500">Afgerond</p>
    </div>
</div>

<?php // ========== AFGEKEURD: opnieuw indienen ========== ?>
<?php if (!empty($rejected)): ?>
<div class="bg-white rounded-xl border border-red-200 mb-6">
    <div class="px-6 py-4 border-b bg-red-50 rounded-t-xl"><h2 class="font-semibold text-red-700">❌ Afgekeurd — opnieuw indienen</h2></div>
    <div class="p-4"><p class="text-sm text-red-600 mb-3">Uw herstelmelding is afgekeurd. Voer het herstel opnieuw uit en dien een nieuwe melding in.</p>
    <table class="w-full"><tbody class="divide-y">
        <?php foreach ($rejected as $t): ?>
        <tr class="hover:bg-gray-50">
            <td class="px-2 py-3 text-sm font-bold"><?= e($t['tuinnummer']) ?></td>
            <td class="px-2 py-3 text-sm"><?= e($t['titel']) ?></td>
            <td class="px-2 py-3 text-sm <?= $t['deadline'] < date('Y-m-d') ? 'text-red-600 font-bold' : 'text-gray-500' ?>"><?= date('d-m-Y', strtotime($t['deadline'])) ?></td>
            <td class="px-2 py-3 text-right"><a href="<?= url('/portaal/herstel/' . $t['id']) ?>" class="px-3 py-1.5 bg-red-600 text-white text-xs rounded-lg hover:bg-red-700">📷 Opnieuw indienen</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table></div>
</div>
<?php endif; ?>

<?php // ========== ACTIE VEREIST ========== ?>
<?php if (!empty($needsAction)): ?>
<div class="bg-white rounded-xl border border-orange-200 mb-6">
    <div class="px-6 py-4 border-b bg-orange-50 rounded-t-xl"><h2 class="font-semibold text-orange-700">⚠️ Actie vereist</h2></div>
    <div class="p-4"><p class="text-sm text-gray-500 mb-3">Onderstaande punten moeten worden hersteld. Maak foto's van het herstel en dien een melding in.</p>
    <table class="w-full"><tbody class="divide-y">
        <?php foreach ($needsAction as $t): ?>
        <tr class="hover:bg-gray-50">
            <td class="px-2 py-3 text-sm font-bold"><?= e($t['tuinnummer']) ?></td>
            <td class="px-2 py-3 text-sm"><?= e($t['titel']) ?></td>
            <td class="px-2 py-3">
                <?php $kl = ['oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700']; ?>
                <span class="text-xs px-2 py-1 rounded <?= $kl[$t['status']] ?? '' ?>"><?= ucfirst($t['status']) ?></span>
            </td>
            <td class="px-2 py-3 text-sm <?= $t['deadline'] < date('Y-m-d') ? 'text-red-600 font-bold' : 'text-gray-500' ?>"><?= date('d-m-Y', strtotime($t['deadline'])) ?><?= $t['deadline'] < date('Y-m-d') ? ' ⚠️' : '' ?></td>
            <td class="px-2 py-3 text-right"><a href="<?= url('/portaal/herstel/' . $t['id']) ?>" class="px-3 py-1.5 bg-groen-600 text-white text-xs rounded-lg hover:bg-groen-700">📷 Herstelmelding</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table></div>
</div>
<?php endif; ?>

<?php // ========== WACHT OP BEOORDELING ========== ?>
<?php if (!empty($pendingReview)): ?>
<div class="bg-white rounded-xl border mb-6">
    <div class="px-6 py-4 border-b bg-blue-50 rounded-t-xl"><h2 class="font-semibold text-blue-700">⏳ Wacht op beoordeling</h2></div>
    <div class="p-4"><p class="text-sm text-gray-500 mb-3">Uw herstelmelding is ingediend en wordt beoordeeld door het bestuur.</p>
    <table class="w-full"><tbody class="divide-y">
        <?php foreach ($pendingReview as $t): ?>
        <tr>
            <td class="px-2 py-3 text-sm font-bold"><?= e($t['tuinnummer']) ?></td>
            <td class="px-2 py-3 text-sm"><?= e($t['titel']) ?></td>
            <td class="px-2 py-3 text-sm text-gray-400"><?= $t['laatste_herstel_datum'] ? date('d-m-Y', strtotime($t['laatste_herstel_datum'])) : '' ?></td>
            <td class="px-2 py-3"><span class="text-xs px-2 py-1 rounded bg-blue-100 text-blue-700">⏳ In behandeling</span></td>
        </tr>
        <?php endforeach; ?>
    </tbody></table></div>
</div>
<?php endif; ?>

<?php // ========== ALLES IN ORDE ========== ?>
<?php if (empty($needsAction) && empty($pendingReview) && empty($rejected)): ?>
<div class="bg-groen-50 border border-groen-200 rounded-xl p-6 mb-6 text-center">
    <p class="text-lg font-bold text-groen-700">🎉 Alles in orde!</p>
    <p class="text-sm text-groen-600 mt-1">Er zijn geen openstaande punten voor uw tuin.</p>
</div>
<?php endif; ?>

<?php // ========== INSPECTIES ========== ?>
<?php if (!empty($inspecties)): ?>
<div class="bg-white rounded-xl border mb-6">
    <div class="px-6 py-4 border-b bg-gray-50 rounded-t-xl"><h2 class="font-semibold text-gray-900">🔍 Inspecties</h2></div>
    <table class="w-full"><tbody class="divide-y">
        <?php foreach ($inspecties as $i): ?>
        <tr>
            <td class="px-4 py-3 text-sm"><?= e($i['tuinnummer']) ?></td>
            <td class="px-4 py-3 text-sm text-gray-500"><?= date('d-m-Y', strtotime($i['afgerond_op'] ?? $i['gestart_op'])) ?></td>
            <td class="px-4 py-3 text-sm"><?= e($i['inspecteur_voornaam'] . ' ' . $i['inspecteur_achternaam']) ?></td>
            <td class="px-4 py-3">
                <?php if ($i['eindstatus']):
                    $kl = ['groen'=>'bg-green-100 text-green-700','oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700']; ?>
                <span class="text-xs px-2 py-1 rounded <?= $kl[$i['eindstatus']] ?? '' ?>"><?= ucfirst($i['eindstatus']) ?></span>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody></table>
</div>
<?php endif; ?>

<?php // ========== AFGERONDE TICKETS ========== ?>
<?php if (!empty($resolvedTickets)): ?>
<div class="bg-white rounded-xl border">
    <div class="px-6 py-4 border-b bg-gray-50 rounded-t-xl"><h2 class="font-semibold text-gray-900">✅ Afgerond (<?= count($resolvedTickets) ?>)</h2></div>
    <table class="w-full"><tbody class="divide-y">
        <?php foreach (array_slice($resolvedTickets, 0, 10) as $t): ?>
        <tr><td class="px-4 py-3 text-sm"><?= e($t['titel']) ?></td><td class="px-4 py-3 text-sm text-gray-400"><?= $t['opgelost_op'] ? date('d-m-Y', strtotime($t['opgelost_op'])) : '' ?></td></tr>
        <?php endforeach; ?>
    </tbody></table>
</div>
<?php endif; ?>
