<div class="flex items-center justify-between mb-6">
    <div class="flex items-center space-x-3">
        <a href="<?= url('/admin/paginas') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900"><?= e($pageLabel) ?></h1>
            <p class="text-sm text-gray-500">/<?= e($slug === 'home' ? '' : $slug) ?></p>
        </div>
    </div>
    <a href="<?= url('/' . ($slug === 'home' ? '' : $slug)) ?>" target="_blank" class="text-sm text-groen-600 hover:text-groen-700 flex items-center space-x-1">
        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/></svg>
        <span>Bekijk pagina</span>
    </a>
</div>

<form method="POST" action="<?= url('/admin/paginas/' . $slug) ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <?php
    $sectionData = [];
    foreach ($sections as $s) {
        $sectionData[$s['sectie']] = $s;
    }

    if ($slug === 'home'):
        $sliderActief = ($sectionData['hero_slider_actief']['inhoud'] ?? '0') === '1';
        $sliderFotos = json_decode($sectionData['hero_slider_fotos']['inhoud'] ?? '[]', true) ?: [];
        $huidigeHeroAfbeelding = $sectionData['hero_afbeelding']['afbeelding_pad'] ?? '';
    ?>
    <!-- Hero sectie -->
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900">Hero sectie</h2>
            <p class="text-sm text-gray-500">Het eerste wat bezoekers zien</p>
        </div>
        <div class="p-6 space-y-5">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Hero titel</label>
                <input type="text" name="secties[hero_titel]" 
                       value="<?= e($sectionData['hero_titel']['inhoud'] ?? 'Welkom bij VTV De Beukhoeve') ?>"
                       class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 focus:border-groen-500 outline-none">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Hero subtitel</label>
                <textarea name="secties[hero_subtitel]" rows="2"
                          class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 focus:border-groen-500 outline-none"><?= e($sectionData['hero_subtitel']['inhoud'] ?? '') ?></textarea>
            </div>

            <!-- HERO ACHTERGRONDAFBEELDING -->
            <div class="p-4 bg-blue-50 rounded-xl border border-blue-200">
                <h3 class="font-semibold text-gray-900 text-sm mb-3">🖼️ Hero achtergrondafbeelding</h3>
                <?php if (!empty($huidigeHeroAfbeelding)): ?>
                <div class="flex items-start space-x-4 mb-3">
                    <img src="<?= url('/storage/uploads/media/' . $huidigeHeroAfbeelding) ?>" 
                         alt="Hero" class="h-28 rounded-lg object-cover border shrink-0">
                    <div>
                        <p class="text-xs text-gray-500 mb-2"><?= e($huidigeHeroAfbeelding) ?></p>
                        <label class="flex items-center space-x-2 cursor-pointer">
                            <input type="checkbox" name="verwijder_hero_afbeelding" value="1" class="w-4 h-4 text-red-500 rounded">
                            <span class="text-sm text-red-600">Verwijderen</span>
                        </label>
                    </div>
                </div>
                <p class="text-xs text-gray-500 mb-2">Of upload een nieuwe afbeelding om te vervangen:</p>
                <?php else: ?>
                <p class="text-sm text-gray-500 mb-2">Geen achtergrondafbeelding ingesteld. Upload er één:</p>
                <?php endif; ?>
                <input type="file" name="afbeeldingen[hero_afbeelding]" accept="image/*"
                       class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-blue-100 file:text-blue-700 hover:file:bg-blue-200 cursor-pointer">
            </div>

            <!-- HERO SLIDER -->
            <div class="p-4 bg-gray-50 rounded-xl border">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <h3 class="font-semibold text-gray-900 text-sm">🎞️ Hero Slider</h3>
                        <p class="text-xs text-gray-500">Toon afwisselende achtergrondafbeeldingen (overschrijft de enkele foto hierboven)</p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="hidden" name="secties[hero_slider_actief]" value="0">
                        <input type="checkbox" name="secties[hero_slider_actief]" value="1" <?= $sliderActief ? 'checked' : '' ?> class="sr-only peer">
                        <div class="w-11 h-6 bg-gray-300 rounded-full peer peer-checked:bg-groen-500 transition-colors after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:after:translate-x-full"></div>
                        <span class="ml-2 text-sm font-medium text-gray-700">Aan</span>
                    </label>
                </div>

                <?php if (!empty($sliderFotos)): ?>
                <p class="text-xs font-medium text-gray-600 mb-2">Huidige slider foto's (<?= count($sliderFotos) ?>):</p>
                <div class="grid grid-cols-2 sm:grid-cols-4 gap-3 mb-4">
                    <?php foreach ($sliderFotos as $i => $foto): ?>
                    <div class="relative group" id="slider-wrap-<?= $i ?>">
                        <img src="<?= url('/storage/uploads/media/' . $foto) ?>" alt="" class="h-24 w-full rounded-lg object-cover border">
                        <button type="button" onclick="removeSliderFoto(<?= $i ?>)" 
                                class="absolute top-1 right-1 w-6 h-6 bg-red-500 text-white rounded-full text-xs flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity hover:bg-red-600" title="Verwijderen">✕</button>
                        <input type="hidden" name="slider_fotos_bestaand[]" value="<?= e($foto) ?>" id="slider-foto-<?= $i ?>">
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php else: ?>
                <p class="text-xs text-gray-400 mb-3 italic">Nog geen slider foto's.</p>
                <?php endif; ?>

                <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 hover:border-groen-400 transition-colors">
                    <p class="text-sm font-medium text-gray-600 mb-2">📷 Foto's toevoegen aan slider:</p>
                    <input type="file" name="slider_fotos_nieuw[]" accept="image/*" multiple id="sliderFileInput"
                           class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-groen-50 file:text-groen-700 hover:file:bg-groen-100 cursor-pointer">
                    <p class="text-xs text-gray-400 mt-2">
                        💡 Houd <strong>Ctrl</strong> (of <strong>Cmd</strong>) ingedrukt om meerdere foto's tegelijk te selecteren.
                        Of upload ze één voor één — elke keer dat u opslaat worden ze toegevoegd.
                    </p>
                    <div id="sliderPreview" class="grid grid-cols-4 gap-2 mt-3 hidden"></div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Body content -->
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900">Pagina inhoud</h2>
        </div>
        <div class="p-6">
            <textarea name="secties[body]" id="editor-body" class="tinymce-editor"><?= $sectionData['body']['inhoud'] ?? '' ?></textarea>
        </div>
    </div>

    <!-- Pagina afbeelding -->
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900">Pagina afbeelding</h2>
            <p class="text-sm text-gray-500">Optionele afbeelding bij deze pagina</p>
        </div>
        <div class="p-6">
            <?php if (!empty($sectionData['body']['afbeelding_pad']) && strlen($sectionData['body']['afbeelding_pad']) > 0): ?>
            <div class="mb-3">
                <img src="<?= url('/storage/uploads/media/' . $sectionData['body']['afbeelding_pad']) ?>" 
                     alt="" class="h-40 rounded-lg object-cover">
            </div>
            <?php else: ?>
            <p class="text-sm text-gray-400 mb-2 italic">Nog geen afbeelding geüpload</p>
            <?php endif; ?>
            <input type="file" name="afbeeldingen[body]" accept="image/*"
                   class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-groen-50 file:text-groen-700 hover:file:bg-groen-100">
        </div>
    </div>

    <div class="flex items-center justify-between">
        <a href="<?= url('/admin/paginas') ?>" class="px-4 py-2.5 text-sm text-gray-600 hover:text-gray-800">Annuleren</a>
        <button type="submit" class="px-6 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition">
            💾 Opslaan
        </button>
    </div>
</form>

<script>
function removeSliderFoto(index) {
    var wrap = document.getElementById('slider-wrap-' + index);
    if (wrap) wrap.remove();
}

document.addEventListener('DOMContentLoaded', function() {
    var sliderInput = document.getElementById('sliderFileInput');
    var preview = document.getElementById('sliderPreview');
    if (sliderInput && preview) {
        sliderInput.addEventListener('change', function() {
            preview.innerHTML = '';
            if (this.files.length > 0) {
                preview.classList.remove('hidden');
                var label = document.createElement('p');
                label.className = 'col-span-4 text-xs font-medium text-groen-700';
                label.textContent = this.files.length + ' foto\'s geselecteerd — klik Opslaan om toe te voegen';
                preview.appendChild(label);
                Array.from(this.files).forEach(function(file) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var div = document.createElement('div');
                        div.className = 'relative';
                        div.innerHTML = '<img src="' + e.target.result + '" class="h-20 w-full rounded-lg object-cover border-2 border-groen-400">' +
                            '<span class="absolute bottom-1 left-1 text-[10px] bg-groen-600 text-white px-1.5 py-0.5 rounded font-medium">Nieuw</span>';
                        preview.appendChild(div);
                    };
                    reader.readAsDataURL(file);
                });
            } else {
                preview.classList.add('hidden');
            }
        });
    }

    if (typeof tinymce !== 'undefined') {
        tinymce.init({
            selector: '.tinymce-editor',
            height: 500,
            language: 'nl',
            menubar: 'file edit view insert format',
            plugins: 'lists link image table code fullscreen preview media hr',
            toolbar: 'undo redo | blocks | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright | bullist numlist | link image | table | code fullscreen',
            block_formats: 'Paragraaf=p; Kop 2=h2; Kop 3=h3; Kop 4=h4',
            content_style: 'body { font-family: system-ui, -apple-system, sans-serif; font-size: 15px; line-height: 1.6; color: #1f2937; max-width: 800px; margin: 0 auto; padding: 16px; }',
            image_list: '<?= url('/admin/media/json') ?>',
            file_picker_types: 'image',
            automatic_uploads: true,
            images_upload_handler: function(blobInfo, progress) {
                return new Promise(function(resolve, reject) {
                    var formData = new FormData();
                    formData.append('bestand', blobInfo.blob(), blobInfo.filename());
                    formData.append('map', 'paginas');
                    formData.append('_csrf_token', document.querySelector('input[name=_csrf_token]').value);
                    var xhr = new XMLHttpRequest();
                    xhr.open('POST', '<?= url('/admin/media/upload') ?>');
                    xhr.onload = function() {
                        if (xhr.status === 200) { resolve(JSON.parse(xhr.responseText).url); }
                        else { reject('Upload mislukt: ' + xhr.status); }
                    };
                    xhr.onerror = function() { reject('Upload mislukt.'); };
                    xhr.send(formData);
                });
            },
            branding: false, promotion: false, license_key: 'gpl',
        });
    }
});
</script>
