-- ============================================================
-- VTV De Beukhoeve - Migratie 003: Tuincontrole Systeem
-- ============================================================

-- Controle categorieën (bijv. Tuin algemeen, Tuinhuisje, Beplanting, Veiligheid)
CREATE TABLE IF NOT EXISTS controle_categorieen (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    naam VARCHAR(255) NOT NULL,
    volgorde INT DEFAULT 0,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Controle punten (checklist items per categorie)
CREATE TABLE IF NOT EXISTS controle_punten (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    categorie_id INT UNSIGNED NOT NULL,
    titel VARCHAR(255) NOT NULL,
    omschrijving TEXT,
    reglement_referentie VARCHAR(255) DEFAULT '',
    volgorde INT DEFAULT 0,
    actief TINYINT(1) DEFAULT 1,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (categorie_id) REFERENCES controle_categorieen(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inspecties
CREATE TABLE IF NOT EXISTS inspecties (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    tuin_id INT UNSIGNED NOT NULL,
    inspecteur_id INT UNSIGNED NOT NULL,
    status ENUM('gestart','afgerond','geannuleerd') DEFAULT 'gestart',
    tuinder_aanwezig TINYINT(1) DEFAULT 0,
    toestemming TINYINT(1) DEFAULT 0,
    toestemming_naam VARCHAR(255) DEFAULT '',
    weigert_medewerking TINYINT(1) DEFAULT 0,
    voorgestelde_status ENUM('groen','oranje','rood') NULL,
    override_status ENUM('groen','oranje','rood') NULL,
    override_reden TEXT,
    algemeen_rapport TEXT,
    gestart_op DATETIME DEFAULT CURRENT_TIMESTAMP,
    afgerond_op DATETIME NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (tuin_id) REFERENCES tuinen(id),
    FOREIGN KEY (inspecteur_id) REFERENCES users(id),
    INDEX idx_tuin (tuin_id),
    INDEX idx_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inspectie items (per controlepunt)
CREATE TABLE IF NOT EXISTS inspectie_items (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    inspectie_id INT UNSIGNED NOT NULL,
    controle_punt_id INT UNSIGNED NOT NULL,
    status ENUM('ok','niet_ok','nvt') DEFAULT 'nvt',
    opmerking TEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (inspectie_id) REFERENCES inspecties(id) ON DELETE CASCADE,
    FOREIGN KEY (controle_punt_id) REFERENCES controle_punten(id),
    INDEX idx_inspectie (inspectie_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Foto's (polymorf: inspection_item, herstelmelding, etc.)
CREATE TABLE IF NOT EXISTS fotos (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    entiteit_type VARCHAR(50) NOT NULL,
    entiteit_id INT UNSIGNED NOT NULL,
    bestandspad VARCHAR(500) NOT NULL,
    bijschrift VARCHAR(255) DEFAULT '',
    geupload_door INT UNSIGNED NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (geupload_door) REFERENCES users(id) ON DELETE SET NULL,
    INDEX idx_entiteit (entiteit_type, entiteit_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tickets (gegenereerd uit afgekeurde inspectie-items)
CREATE TABLE IF NOT EXISTS inspectie_tickets (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    inspectie_id INT UNSIGNED NOT NULL,
    tuin_id INT UNSIGNED NOT NULL,
    controle_punt_id INT UNSIGNED NULL,
    status ENUM('groen','oranje','rood') DEFAULT 'oranje',
    titel VARCHAR(255) NOT NULL,
    omschrijving TEXT,
    deadline DATE NULL,
    opgelost_op DATETIME NULL,
    opgelost_door INT UNSIGNED NULL,
    aangemaakt_door INT UNSIGNED NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (inspectie_id) REFERENCES inspecties(id),
    FOREIGN KEY (tuin_id) REFERENCES tuinen(id),
    FOREIGN KEY (aangemaakt_door) REFERENCES users(id),
    FOREIGN KEY (opgelost_door) REFERENCES users(id) ON DELETE SET NULL,
    INDEX idx_tuin (tuin_id),
    INDEX idx_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Herstel meldingen (tuinder meldt dat iets hersteld is)
CREATE TABLE IF NOT EXISTS herstel_meldingen (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    ticket_id INT UNSIGNED NOT NULL,
    tuin_id INT UNSIGNED NOT NULL,
    gemeld_door INT UNSIGNED NOT NULL,
    omschrijving TEXT,
    status ENUM('ingediend','goedgekeurd','afgekeurd') DEFAULT 'ingediend',
    beoordeeld_door INT UNSIGNED NULL,
    beoordeling_opmerking TEXT,
    beoordeeld_op DATETIME NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (ticket_id) REFERENCES inspectie_tickets(id),
    FOREIGN KEY (tuin_id) REFERENCES tuinen(id),
    FOREIGN KEY (gemeld_door) REFERENCES users(id),
    FOREIGN KEY (beoordeeld_door) REFERENCES users(id) ON DELETE SET NULL,
    INDEX idx_ticket (ticket_id),
    INDEX idx_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Brieven (waarschuwingen etc.)
CREATE TABLE IF NOT EXISTS brieven (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    tuin_id INT UNSIGNED NOT NULL,
    inspectie_id INT UNSIGNED NULL,
    type VARCHAR(100) NOT NULL,
    onderwerp VARCHAR(255) NOT NULL,
    inhoud TEXT NOT NULL,
    zichtbaar_voor_tuinder TINYINT(1) DEFAULT 0,
    verstuurd_op DATETIME NULL,
    verstuurd_methode VARCHAR(50) NULL,
    aangemaakt_door INT UNSIGNED NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (tuin_id) REFERENCES tuinen(id),
    FOREIGN KEY (inspectie_id) REFERENCES inspecties(id) ON DELETE SET NULL,
    FOREIGN KEY (aangemaakt_door) REFERENCES users(id),
    INDEX idx_tuin (tuin_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================================
-- Standaard categorieën en controle punten
-- ============================================================
INSERT INTO controle_categorieen (naam, volgorde) VALUES
('Tuin algemeen', 0),
('Tuinhuisje / Opstal', 1),
('Beplanting', 2),
('Veiligheid', 3);

SET @cat1 = (SELECT id FROM controle_categorieen WHERE naam = 'Tuin algemeen');
SET @cat2 = (SELECT id FROM controle_categorieen WHERE naam = 'Tuinhuisje / Opstal');
SET @cat3 = (SELECT id FROM controle_categorieen WHERE naam = 'Beplanting');
SET @cat4 = (SELECT id FROM controle_categorieen WHERE naam = 'Veiligheid');

INSERT INTO controle_punten (categorie_id, titel, volgorde) VALUES
(@cat1, 'Tuin onderhouden en vrij van onkruid', 0),
(@cat1, 'Paden begaanbaar', 1),
(@cat1, 'Geen rommel of afval', 2),
(@cat1, 'Composthoop goed onderhouden', 3),
(@cat2, 'Bouwwerk in goede staat', 0),
(@cat2, 'Dakbedekking intact', 1),
(@cat2, 'Geen illegale uitbreidingen', 2),
(@cat2, 'Verfwerk in orde', 3),
(@cat3, 'Bomen niet over erfgrens', 0),
(@cat3, 'Heggen op juiste hoogte', 1),
(@cat3, 'Geen verboden planten', 2),
(@cat4, 'Waterafvoer functioneert', 0),
(@cat4, 'Geen brandgevaar', 1),
(@cat4, 'Elektra veilig aangelegd', 2);
