<?php
$dbContent = $content['body']['inhoud'] ?? '';
if ($dbContent): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="prose prose-lg max-w-none bg-white rounded-xl shadow-sm border border-gray-100 p-8">
        <?= $dbContent ?>
    </div>
</section>
<?php else: ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h1 class="text-3xl font-bold text-gray-900 mb-2">Bestuur</h1>
    <p class="text-gray-500 mb-10">Het bestuur van VTV De Beukhoeve.</p>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if (!empty($bestuur)): ?>
            <?php foreach ($bestuur as $lid): ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 text-center">
                <div class="w-20 h-20 bg-groen-100 rounded-full mx-auto mb-4 flex items-center justify-center">
                    <?php if ($lid['foto']): ?>
                        <img src="<?= e($lid['foto']) ?>" alt="" class="w-20 h-20 rounded-full object-cover">
                    <?php else: ?>
                        <span class="text-2xl text-groen-600">
                            <?= strtoupper(substr($lid['voornaam'] ?? '?', 0, 1)) ?>
                        </span>
                    <?php endif; ?>
                </div>
                <h3 class="font-semibold text-gray-900">
                    <?= e(($lid['voornaam'] ?? '') . ' ' . ($lid['achternaam'] ?? '')) ?>
                </h3>
                <p class="text-groen-600 text-sm font-medium mt-1"><?= e($lid['functie']) ?></p>
                <?php if ($lid['beschrijving']): ?>
                <p class="text-gray-500 text-sm mt-3"><?= e($lid['beschrijving']) ?></p>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-span-full text-center text-gray-400 py-8">
                Bestuursleden worden binnenkort toegevoegd.
            </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?>
