<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Ledenbeheer</h1>
        <p class="text-sm text-gray-500 mt-1"><?= $totaalActief ?> actief · <?= $totaalInactief ?> inactief</p>
    </div>
    <a href="<?= url('/admin/leden/nieuw') ?>" class="px-4 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition flex items-center space-x-2">
        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
        <span>Nieuw lid</span>
    </a>
</div>

<!-- Filters -->
<div class="bg-white rounded-xl border border-gray-200 p-4 mb-6">
    <form method="GET" action="<?= url('/admin/leden') ?>" class="flex flex-wrap gap-3 items-end">
        <div class="flex-1 min-w-[200px]">
            <label class="block text-xs font-medium text-gray-500 mb-1">Zoeken</label>
            <input type="text" name="zoek" value="<?= e($filters['zoek']) ?>" placeholder="Naam, e-mail, lidnummer, tuinnummer..."
                   class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
        </div>
        <div class="w-36">
            <label class="block text-xs font-medium text-gray-500 mb-1">Status</label>
            <select name="actief" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                <option value="">Alle</option>
                <option value="1" <?= $filters['actief'] === '1' ? 'selected' : '' ?>>Actief</option>
                <option value="0" <?= $filters['actief'] === '0' ? 'selected' : '' ?>>Inactief</option>
            </select>
        </div>
        <div class="w-40">
            <label class="block text-xs font-medium text-gray-500 mb-1">Rol</label>
            <select name="role" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 outline-none">
                <option value="">Alle rollen</option>
                <?php foreach ($roles as $role): ?>
                <option value="<?= $role['id'] ?>" <?= $filters['role_id'] == $role['id'] ? 'selected' : '' ?>><?= e($role['naam']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="px-4 py-2 bg-gray-100 text-gray-700 text-sm rounded-lg hover:bg-gray-200">Zoeken</button>
        <?php if ($filters['zoek'] || $filters['actief'] !== '' || $filters['role_id']): ?>
        <a href="<?= url('/admin/leden') ?>" class="px-4 py-2 text-sm text-gray-500 hover:text-gray-700">Wis filters</a>
        <?php endif; ?>
    </form>
</div>

<!-- Ledenlijst -->
<div class="bg-white rounded-xl border border-gray-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Lid</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Lidnr</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tuin</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Rol</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Status</th>
                    <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase">Acties</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php if (empty($leden)): ?>
                <tr><td colspan="6" class="px-4 py-8 text-center text-gray-400">Geen leden gevonden</td></tr>
                <?php endif; ?>
                <?php foreach ($leden as $lid): ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <a href="<?= url('/admin/leden/' . $lid['id']) ?>" class="flex items-center space-x-3">
                            <div class="w-9 h-9 bg-groen-100 rounded-full flex items-center justify-center text-sm font-bold text-groen-700">
                                <?= strtoupper(substr($lid['voornaam'], 0, 1) . substr($lid['achternaam'], 0, 1)) ?>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900">
                                    <?= e($lid['voornaam']) ?> <?= e($lid['tussenvoegsel'] ?? '') ?> <?= e($lid['achternaam']) ?>
                                </p>
                                <p class="text-xs text-gray-400"><?= e($lid['email']) ?></p>
                            </div>
                        </a>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600"><?= e($lid['lidnummer'] ?? '—') ?></td>
                    <td class="px-4 py-3 text-sm text-gray-600"><?= e($lid['tuinnummer'] ?? '—') ?></td>
                    <td class="px-4 py-3">
                        <span class="text-xs px-2 py-1 rounded-full bg-gray-100 text-gray-600"><?= e($lid['role_naam'] ?? 'Lid') ?></span>
                    </td>
                    <td class="px-4 py-3">
                        <?php if ($lid['actief']): ?>
                        <span class="text-xs px-2 py-1 rounded-full bg-groen-100 text-groen-700">Actief</span>
                        <?php else: ?>
                        <span class="text-xs px-2 py-1 rounded-full bg-red-100 text-red-700">Inactief</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-4 py-3 text-right">
                        <a href="<?= url('/admin/leden/' . $lid['id'] . '/bewerk') ?>" class="text-sm text-blue-600 hover:text-blue-800">Bewerken</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
