<div class="flex items-center space-x-3 mb-6">
    <a href="<?= url('/admin/inspecties/herstelmeldingen') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
    </a>
    <h1 class="text-2xl font-bold text-gray-900">Herstelmelding #<?= $melding['id'] ?></h1>
</div>
<div class="max-w-3xl grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="space-y-4">
        <div class="bg-white rounded-xl border p-6">
            <h3 class="font-semibold mb-3">Details</h3>
            <div class="text-sm space-y-2">
                <p><span class="text-gray-500">Tuin:</span> <strong><?= e($melding['tuinnummer']) ?></strong></p>
                <p><span class="text-gray-500">Ticket:</span> <?= e($melding['ticket_titel']) ?></p>
                <p><span class="text-gray-500">Gemeld door:</span> <?= e($melding['voornaam'] . ' ' . $melding['achternaam']) ?></p>
                <p><span class="text-gray-500">Datum:</span> <?= date('d-m-Y H:i', strtotime($melding['created_at'])) ?></p>
            </div>
            <?php if ($melding['omschrijving']): ?>
            <div class="mt-4 p-3 bg-gray-50 rounded-lg text-sm"><?= nl2br(e($melding['omschrijving'])) ?></div>
            <?php endif; ?>
        </div>
        <?php if (!empty($photos)): ?>
        <div class="bg-white rounded-xl border p-6">
            <h3 class="font-semibold mb-3">Foto's</h3>
            <div class="grid grid-cols-2 gap-2">
                <?php foreach ($photos as $p): ?>
                <a href="<?= url('/storage/uploads/inspecties/' . $p['bestandspad']) ?>" target="_blank">
                    <img src="<?= url('/storage/uploads/inspecties/' . $p['bestandspad']) ?>" class="w-full h-32 object-cover rounded-lg border">
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <div>
        <form method="POST" action="<?= url('/admin/inspecties/herstelmeldingen/' . $melding['id'] . '/review') ?>" class="bg-white rounded-xl border p-6 space-y-4">
            <?= csrf_field() ?>
            <h3 class="font-semibold">Beoordeling</h3>
            <div class="space-y-2">
                <label class="flex items-center space-x-3 p-3 border rounded-lg cursor-pointer hover:bg-green-50">
                    <input type="radio" name="status" value="goedgekeurd" required>
                    <span class="text-sm">✅ Goedkeuren — ticket wordt op groen gezet</span>
                </label>
                <label class="flex items-center space-x-3 p-3 border rounded-lg cursor-pointer hover:bg-red-50">
                    <input type="radio" name="status" value="afgekeurd">
                    <span class="text-sm">❌ Afkeuren — tuinder moet opnieuw herstellen</span>
                </label>
            </div>
            <textarea name="beoordeling_opmerking" rows="3" class="w-full px-3 py-2 border rounded-lg text-sm" placeholder="Opmerking (optioneel)..."></textarea>
            <button type="submit" class="w-full py-2.5 bg-groen-600 text-white font-medium rounded-lg hover:bg-groen-700">Beoordeling opslaan</button>
        </form>
    </div>
</div>
