<?php

namespace App\Models;

use App\Core\Database;

class Content
{
    /**
     * Haal content op voor een pagina en sectie
     */
    public static function get(string $slug, string $sectie = 'body'): ?array
    {
        $db = Database::getInstance();
        return $db->fetch(
            "SELECT * FROM pagina_content WHERE pagina_slug = ? AND sectie = ? AND actief = 1",
            [$slug, $sectie]
        );
    }

    /**
     * Haal alle content voor een pagina op
     */
    public static function getAllForPage(string $slug): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT * FROM pagina_content WHERE pagina_slug = ? AND actief = 1 ORDER BY volgorde",
            [$slug]
        );
    }

    /**
     * Haal alle bewerkbare pagina's op
     */
    public static function getPages(): array
    {
        $db = Database::getInstance();
        return $db->fetchAll(
            "SELECT pagina_slug, 
                    GROUP_CONCAT(sectie ORDER BY volgorde) as secties,
                    MAX(updated_at) as laatst_bijgewerkt
             FROM pagina_content 
             GROUP BY pagina_slug 
             ORDER BY pagina_slug"
        );
    }

    /**
     * Update of maak content aan
     */
    public static function save(string $slug, string $sectie, array $data): bool
    {
        $db = Database::getInstance();
        $existing = self::get($slug, $sectie);

        if ($existing) {
            return $db->update('pagina_content', $data, 'id = ?', [$existing['id']]);
        } else {
            $data['pagina_slug'] = $slug;
            $data['sectie'] = $sectie;
            return $db->insert('pagina_content', $data) > 0;
        }
    }

    /**
     * Haal de inhoud tekst op (shortcut)
     */
    public static function tekst(string $slug, string $sectie = 'body', string $default = ''): string
    {
        $content = self::get($slug, $sectie);
        return $content['inhoud'] ?? $default;
    }
}
