<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Media bibliotheek</h1>
    <button onclick="document.getElementById('upload-modal').classList.remove('hidden')" 
            class="px-4 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition flex items-center space-x-2">
        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
        <span>Uploaden</span>
    </button>
</div>

<!-- Stats -->
<div class="mb-6 text-sm text-gray-500">
    <?= $total ?> bestand<?= $total !== 1 ? 'en' : '' ?>
</div>

<!-- Grid -->
<?php if (empty($items)): ?>
<div class="bg-white rounded-xl border border-gray-200 p-12 text-center">
    <svg class="w-16 h-16 text-gray-300 mx-auto mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
    <p class="text-gray-500 mb-4">Nog geen media bestanden geüpload.</p>
    <button onclick="document.getElementById('upload-modal').classList.remove('hidden')" 
            class="px-4 py-2 bg-groen-600 text-white text-sm rounded-lg hover:bg-groen-700">
        Eerste bestand uploaden
    </button>
</div>
<?php else: ?>
<div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4">
    <?php foreach ($items as $item): ?>
    <div class="group relative bg-white rounded-xl border border-gray-200 overflow-hidden hover:shadow-md transition">
        <?php if (str_starts_with($item['mime_type'], 'image/')): ?>
        <div class="aspect-square bg-gray-100">
            <img src="<?= url('/storage/uploads/media/' . $item['bestandsnaam']) ?>" 
                 alt="<?= e($item['alt_tekst'] ?? $item['originele_naam']) ?>"
                 class="w-full h-full object-cover">
        </div>
        <?php else: ?>
        <div class="aspect-square bg-gray-50 flex items-center justify-center">
            <svg class="w-12 h-12 text-gray-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
        </div>
        <?php endif; ?>
        <div class="p-2">
            <p class="text-xs text-gray-600 truncate"><?= e($item['originele_naam']) ?></p>
            <p class="text-xs text-gray-400"><?= number_format($item['bestandsgrootte'] / 1024) ?> KB</p>
        </div>
        <!-- Delete button -->
        <form method="POST" action="<?= url('/admin/media/' . $item['id'] . '/delete') ?>" 
              class="absolute top-2 right-2 opacity-0 group-hover:opacity-100 transition"
              onsubmit="return confirm('Dit bestand verwijderen?')">
            <?= csrf_field() ?>
            <button type="submit" class="p-1.5 bg-red-500 text-white rounded-lg hover:bg-red-600 shadow-lg">
                <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
            </button>
        </form>
        <!-- Copy URL -->
        <button onclick="copyUrl('<?= url('/storage/uploads/media/' . $item['bestandsnaam']) ?>')" 
                class="absolute top-2 left-2 opacity-0 group-hover:opacity-100 transition p-1.5 bg-white text-gray-600 rounded-lg hover:bg-gray-100 shadow-lg" title="URL kopiëren">
            <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/></svg>
        </button>
    </div>
    <?php endforeach; ?>
</div>

<!-- Paginering -->
<?php if ($totalPages > 1): ?>
<div class="flex justify-center mt-8 space-x-2">
    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
    <a href="<?= url('/admin/media?pagina=' . $i) ?>" 
       class="px-3 py-2 text-sm rounded-lg <?= $i === $currentPage ? 'bg-groen-600 text-white' : 'bg-white border text-gray-600 hover:bg-gray-50' ?>">
        <?= $i ?>
    </a>
    <?php endfor; ?>
</div>
<?php endif; ?>
<?php endif; ?>

<!-- Upload Modal -->
<div id="upload-modal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-black/50">
    <div class="bg-white rounded-2xl w-full max-w-lg mx-4 shadow-xl">
        <div class="flex items-center justify-between px-6 py-4 border-b">
            <h2 class="font-semibold text-gray-900">Bestand uploaden</h2>
            <button onclick="document.getElementById('upload-modal').classList.add('hidden')" class="text-gray-400 hover:text-gray-600">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <form method="POST" action="<?= url('/admin/media/upload') ?>" enctype="multipart/form-data" class="p-6">
            <?= csrf_field() ?>
            <input type="hidden" name="map" value="algemeen">
            
            <div id="drop-zone" class="border-2 border-dashed border-gray-300 rounded-xl p-8 text-center hover:border-groen-400 transition cursor-pointer"
                 onclick="document.getElementById('file-input').click()">
                <svg class="w-12 h-12 text-gray-300 mx-auto mb-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/></svg>
                <p class="text-sm text-gray-600 mb-1">Klik of sleep een bestand</p>
                <p class="text-xs text-gray-400">JPG, PNG, GIF, WebP, SVG, PDF — Max 10MB</p>
            </div>
            <input type="file" id="file-input" name="bestand" accept="image/*,.pdf" class="hidden" onchange="this.form.submit()">
        </form>
    </div>
</div>

<script>
function copyUrl(url) {
    var fullUrl = window.location.origin + url;
    navigator.clipboard.writeText(fullUrl).then(function() {
        alert('URL gekopieerd!');
    });
}

// Drag and drop
var dropZone = document.getElementById('drop-zone');
if (dropZone) {
    ['dragenter', 'dragover'].forEach(e => {
        dropZone.addEventListener(e, function(ev) {
            ev.preventDefault();
            dropZone.classList.add('border-groen-400', 'bg-groen-50');
        });
    });
    ['dragleave', 'drop'].forEach(e => {
        dropZone.addEventListener(e, function(ev) {
            ev.preventDefault();
            dropZone.classList.remove('border-groen-400', 'bg-groen-50');
        });
    });
    dropZone.addEventListener('drop', function(ev) {
        var files = ev.dataTransfer.files;
        if (files.length > 0) {
            document.getElementById('file-input').files = files;
            document.getElementById('file-input').form.submit();
        }
    });
}
</script>
